/*
 * $Id: RubyScriptLink.java,v 1.1 2004/01/17 12:08:03 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import java.io.IOException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.*;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.publish.*;
import com.narucy.webpub.ui.WebpubUIPlugin;

class RubyScriptLink implements IRelativeResourceLinkChooser {

	public IFile chooseLink(final ITextEditor editor) throws CoreException {
		IEditorInput input = editor.getEditorInput();
		if( input instanceof IFileEditorInput ){
			IFile htFile = ((IFileEditorInput)input).getFile();
		
			PublishDescription publishDesc = null;
			try {
				publishDesc = PublishDescriptionFactory.getInstance().create(htFile);
			} catch (IllegalConfigurationException ex) {
				new CoreException(new Status(
					IStatus.ERROR,
					WebpubUIPlugin.ID_PLUGIN,
					IStatus.OK,
					ex.getLocalizedMessage(),
					ex));
			} catch (IOException ex) {
				WebpubUIPlugin.handleException(ex);
			}
			
			if( publishDesc != null){
				String scriptPath = publishDesc.getArgument("script");
				if( scriptPath != null){
					try{
						WebProject webProject = (WebProject)htFile.getProject().getNature(WebProject.ID_NATURE);
						return webProject.getFolder(WebProject.KEY_SCRIPTS_FOLDER).getFile(new Path(scriptPath));
					}catch(CoreException e){
						WebpubUIPlugin.handleException(e);
					}
				}
			}
		}
		
		return null;
	}
	
}

