/*
 * $Id: HTPartitionScanner.java,v 1.1 2004/01/17 12:08:03 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import org.eclipse.jface.text.rules.*;

public class HTPartitionScanner extends RuleBasedPartitionScanner {
	
	public final static String
		HTML_DEFAULT = "__html_default",
		HTML_COMMENT = "__html_comment",
		HTML_ERB = "__html_erb",
		HTML_TAG = "__html_tag";

	public HTPartitionScanner() {
		IPredicateRule[] rules = new IPredicateRule[3];

		Token comment = new Token(HTML_COMMENT);
		rules[0] = new MultiLineRule("<!--", "-->", comment);

		Token erb = new Token(HTML_ERB);
		rules[1] = new MultiLineRule("<%", "%>", erb);

		Token tag = new Token(HTML_TAG);
		rules[2] = new HTTagRule(tag);

		setPredicateRules(rules);
	}
}
