/*
 * $Id: HTOutlinePage.java,v 1.1 2004/01/17 12:08:03 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

/**
 * HTOutlinePage
 * TODO: changable header outline and xml tree outline.
 */
public class HTOutlinePage extends ContentOutlinePage {

	IDocument doc;
	
	public HTOutlinePage(IDocument doc) {
		super();
		Assert.isNotNull(doc);
		this.doc = doc;
	}

	public void createControl(Composite parent) {
		super.createControl(parent);
		
		TreeViewer viewer= getTreeViewer();
		viewer.setLabelProvider(new HTLabelProvider());
		viewer.setContentProvider(new HTOutlineContentProvider());
		viewer.setInput(doc);
		
		viewer.setAutoExpandLevel(AbstractTreeViewer.ALL_LEVELS);
		viewer.expandAll();
	}
	
	void p(Object o) {
		System.out.println(getClass() + ":" + o);
	}

}

