/*
 * $Id: HTOutlineContentProvider.java,v 1.1 2004/01/17 12:08:02 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import java.util.Iterator;

import org.eclipse.jface.text.*;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.narucy.webpub.core.template.*;

class DocLineIterator implements Iterator{
		
	int lineIndex = 0;
	IDocument doc;
		
	DocLineIterator(IDocument doc){
		this.doc = doc;
	}
				
	public boolean hasNext() {
		return lineIndex < doc.getNumberOfLines();
	}

	public Object next() {
		try{
			IRegion region = doc.getLineInformation(lineIndex);
			String line = doc.get(region.getOffset(), region.getLength());
			return line;
		} catch (BadLocationException e) {
			e.printStackTrace();
			return null;
		}
		finally{
			lineIndex++;
		}
	}

	public void remove() {}
}


/**
 * 
 */
public class HTOutlineContentProvider implements ITreeContentProvider {

	Viewer viewer = null;

	public Object getParent(Object element) {
		return null;
	}

	public boolean hasChildren(Object element) {
		if(element instanceof Template){
			Template tmpl = (Template)element;
			return (tmpl.getChildrenTemplates().length > 0);
		}
		return false;
	}
	
	public Object[] getChildren(Object parentElement) {
		if(parentElement instanceof Template){
			Template tmpl = (Template)parentElement;
			return tmpl.getChildrenTemplates();
		}
		return null;
	}


	public Object[] getElements(Object inputElement) {
		final IDocument doc = (IDocument) inputElement;
		try {
			Template rootTmpl = TemplateParser.getInstance().parse(new DocLineIterator(doc), "Root");
			return new Object[]{ rootTmpl };
		} catch (TemplateParseException e) {
		}
		return new Object[0];
	}

	public void dispose() {
	}

	IDocumentListener docListener = new IDocumentListener(){
		public void documentAboutToBeChanged(DocumentEvent event) {
		}

		public void documentChanged(DocumentEvent event) {
			viewer.refresh();
		}
	};

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		this.viewer = viewer;
		if (oldInput != null) {
			((IDocument)oldInput).removeDocumentListener(docListener);
		}
		if (newInput != null) {
			((IDocument)newInput).addDocumentListener(docListener);
		}
	}


}
