/*
 * $Id: HTLabelProvider.java,v 1.1 2004/01/17 12:08:02 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

import com.narucy.webpub.core.template.Template;
import com.narucy.webpub.core.template.TemplateParseException;
import com.narucy.webpub.ui.WebpubUIPlugin;

class TemplateProvider extends LabelProvider {

	Image tmplImage = null;

	public TemplateProvider(){
	}
	
	synchronized void initImage(){
		WebpubUIPlugin plugin = WebpubUIPlugin.getDefault();
		tmplImage = plugin.getImageDescriptor("obj16/template.gif").createImage();

		IDecoratorManager decoratorManager =
			WebpubUIPlugin.getDefault().getWorkbench().getDecoratorManager();
		try {
			decoratorManager.setEnabled("com.narucy.webpub.ui.editors.ErrorDecorator", true);
		} catch (CoreException e) {
			WebpubUIPlugin.handleException(e);
		}
	}
	
	public String getText(Object element) {
		if(element instanceof Template){
			Template teml = (Template)element;
			return teml.getName();
		}
		else if(element instanceof TemplateParseException){
			TemplateParseException e = (TemplateParseException)element;
			return "Parse Error - " + e.getLineText();
		}
		return super.getText(element);
	}

	public Image getImage(Object element) {
		if(tmplImage == null){
			initImage();
		}
		if(element instanceof Template){
			return tmplImage;
		}
		else if(element instanceof TemplateParseException){
			return tmplImage;
		}
		return null;
	}
	
	public void dispose() {
		if(tmplImage != null){
			tmplImage.dispose();
		}
	}

}

/**
 * 
 */
public class HTLabelProvider extends DecoratingLabelProvider {

	public HTLabelProvider() {
		this(new TemplateProvider());
	}
	
	HTLabelProvider(TemplateProvider provider){
		super(provider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
	}


}
