/*
 * $Id: HTContentAssistEngine.java,v 1.1 2004/01/17 12:08:02 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.*;

import javax.xml.parsers.*;

import org.w3c.dom.*;
import org.xml.sax.SAXException;

import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * 
 */
class HTContentAssistEngine {

	final static String RNG_BASE_DIR = "resources/xhtml_rng/";

	final public static String
		XHTML_BASIC = "xhtml-basic.rng",
		XHTML_STRICT = "xhtml-strict.rng",
		XHTML_TRANSITIONAL = "xhtml.rng";
	
	static HTContentAssistEngine instance = new HTContentAssistEngine();
	
	public static HTContentAssistEngine getInstance(){
		return instance;
	}

	String currentType = null;
	URL xhtmlRelaxNGBaseUrl;

	HashMap
		rngReadCache = new HashMap(),
		definedCache = new HashMap(),
		bindedDefineCache = new HashMap(),
		childElementsCache = new HashMap(),
		attributesCache = new HashMap();
	
	DocumentBuilder builder;
	
	public HTContentAssistEngine() {
		DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
		try {
			builder = docBuilderFactory.newDocumentBuilder();
		} catch (ParserConfigurationException e) {
			throw new RuntimeException(e);
		}
		if( WebpubUIPlugin.getDefault() != null){
			xhtmlRelaxNGBaseUrl = WebpubUIPlugin.getResource(RNG_BASE_DIR);
		}else{
			try {
				xhtmlRelaxNGBaseUrl = new File(RNG_BASE_DIR).toURL();
			} catch (MalformedURLException e1) {
			}
		}
	}
	
	/**
	 * <p>
	 * Returns current html type of constants these are
	 * XHTML_BASIC, XHTML_STRICT, XHTML_TRANSITIONAL.
	 * <p>
	 * If not initialize a engine return null.
	 */
	public String getCurrentType(){
		return currentType;
	}

	public void initTypes(String type) throws ParserConfigurationException, SAXException, IOException{
		this.currentType = type;
		
		definedCache.clear();
		bindedDefineCache.clear();
		childElementsCache.clear();
		attributesCache.clear();
		
		URL url = new URL(xhtmlRelaxNGBaseUrl, type);
		doInitGrammar( getDocumentElement(url), url);
	}
	
	public Element getDocumentElement(URL url) throws SAXException, IOException{
		Element e = (Element)rngReadCache.get(url);
		if(e == null){
			Document doc = builder.parse(url.openStream());
			e = doc.getDocumentElement();
			rngReadCache.put(url, e);
		}
		return e;
	}

	void doInitGrammar(Element elem, URL loadedUrl) throws MalformedURLException, DOMException, SAXException, IOException{
		NodeList nl = elem.getChildNodes();
		for(int i=0; i<nl.getLength(); i++){
			if(nl.item(i) instanceof Element){
				Element e = (Element)nl.item(i);
				String elemName = e.getTagName();
				if(elemName.equals("include")){
					URL url = new URL(loadedUrl, e.getAttribute("href"));
					doInitGrammar( getDocumentElement(url), url);
				}else if( elemName.equals("define") ){
					String name = e.getAttribute("name");
					if( definedCache.containsKey(name) && e.getAttribute("combine") != null){
						addBindedElem(e);
					}else{
						definedCache.put(name, e);
					}
				}
			}
		}
	}
	
	void addBindedElem(Element e){
		String name = e.getAttribute("name");
		List list = (List)bindedDefineCache.get(name);
		if(list == null){
			list = new ArrayList();
			bindedDefineCache.put(name, list);
		}
		list.add(e);
	}

	public String[] getCandidateElements(String elemName) {
		if( !childElementsCache.containsKey(elemName)){
			String[] elems = findChildElements(elemName);
			if( elems != null){
				Arrays.sort(elems);
			}
			childElementsCache.put(elemName, elems);
		}
		return (String[])childElementsCache.get(elemName);
	}
	
	Element findHTElement(String elemName){
		Object[] defs = definedCache.values().toArray();
		for(int i=0; i<defs.length; i++){
			NodeList ls = ((Element)defs[i]).getElementsByTagName("element");
			for(int j=0; j<ls.getLength(); j++){
				Element e = (Element)ls.item(j);
				if( e.getAttribute("name").equals(elemName) ){
					return e;
				}
			}
		}
		return null;
	}
	
	String[] findChildElements(String elemName){
		Element elem = findHTElement(elemName);
		if( elem == null){
			return null;
		}

		Element[] childs = toFlatChildren(elem);
		ArrayList dist = new ArrayList();
		for (int i = 0; i < childs.length; i++) {
			Element e = childs[i];
			if( e.getTagName().equals("element") ){
				dist.add( e.getAttribute("name") );
			}
		}
		return dist.size() > 0 ? (String[])dist.toArray(new String[dist.size()]) : null;
	}

	public String[] getCandidateAttribute(String elementName){
		if(!attributesCache.containsKey(elementName)){
			String[] attrs = findAttributes(elementName);
			if( attrs != null){
				Arrays.sort(attrs);
			}
			attributesCache.put(elementName, attrs);
		}
		return (String[])attributesCache.get(elementName);
	}

	String[] findAttributes(String name){
		Element elem = findHTElement(name);
		if(elem == null){
			return null;
		}
		Element[] childs = toFlatChildren(elem);
		ArrayList dist = new ArrayList();
		for (int i = 0; i < childs.length; i++) {
			Element e = childs[i];
			if( e.getTagName().equals("attribute") ){
				dist.add(e.getAttribute("name"));
			}
		}
		return dist.size() > 0 ? (String[])dist.toArray(new String[dist.size()]) : null;
	}
	
	public boolean isEmptyElement(String elemName){
		return findHTElement(elemName).getElementsByTagName("empty").getLength() > 0;
	}
	
	Element[] toFlatChildren(Element elem){
		ArrayList dist = new ArrayList();
		toFlat(elem, dist);
		return (Element[])dist.toArray(new Element[dist.size()]);
	}
	
	void toFlat(Element elem, List dist){
		NodeList nl = elem.getChildNodes();
		for(int i=0; i<nl.getLength(); i++){
			if (nl.item(i) instanceof Element){
				Element e = (Element)nl.item(i);
				dist.add(e);
				
				String tn = e.getTagName();
				if( tn.equals("zeroOrMore") || tn.equals("oneOrMore") ||  tn.equals("choice") || tn.equals("optional")){
					toFlat(e, dist);
				}else if(tn.equals("ref") ){
					String name = e.getAttribute("name");
					toFlat( (Element)definedCache.get(name), dist);
					List elems = (List)bindedDefineCache.get(name);
					for(int j=0; elems != null && j<elems.size(); j++){
						toFlat( (Element)elems.get(j), dist);
					}
				}
			}
		}
	}
	
	
}
