/*
 * $Id: CSSLink.java,v 1.1 2004/01/17 12:08:03 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * CSSLink
 */
class CSSLink implements IRelativeResourceLinkChooser {

	static Pattern cssLinkPattern =
		Pattern.compile("^<link\\s+.*rel=\"stylesheet\".*.*href=\"(.+\\.css)\".*\\s*");

	public IFile chooseLink(ITextEditor editor) {
		IEditorInput input = editor.getEditorInput();
		if( input instanceof IFileEditorInput ){
			IDocument doc =
				editor.getDocumentProvider().getDocument( editor.getEditorInput() );
			
			try{
				for(int i=0; i<doc.getNumberOfLines(); i++){
					String line = doc.get(doc.getLineOffset(i), doc.getLineLength(i));

					Matcher match = cssLinkPattern.matcher(line);
					if( match.matches() ){
						String path = match.group(1);
						IFile htFile = ((IFileEditorInput)input).getFile();
					
						IFile cssFile;
						if( path.charAt(0) == '/'){
							path = path.substring(1);
							IProject proj = htFile.getProject();
							try {
								WebProject wp = (WebProject)proj.getNature(WebProject.ID_NATURE);
								cssFile = wp.getFolder(WebProject.KEY_HTSOURCES_FOLDER).getFile(new Path(path));
							} catch (CoreException e1) {
								cssFile = proj.getFile(path);
							}
						}else{
							cssFile = htFile.getParent().getFile( new Path(path) );
						}
						return cssFile;
					}
				}
			}catch(BadLocationException ex){
				WebpubUIPlugin.handleException(ex);
			}
		}
		return null;
	}

}
