/*
 * $Id: UnescapeTagAction.java,v 1.1 2004/01/17 12:08:05 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import java.util.Arrays;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.*;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

import com.narucy.webpub.core.HTMLUtilities;
import com.narucy.webpub.ui.WebpubUIPlugin;

public class UnescapeTagAction implements IEditorActionDelegate {

	final String[] replaceStrings;

	ITextEditor editor = null;
	ITextSelection selection = null;
	
	public UnescapeTagAction(){
		this(new String[]{"&gt;", "&lt;", "&quot;", "&amp;"});
	}
	
	public UnescapeTagAction(String[] replaceStrings){
		this.replaceStrings = replaceStrings;
		Arrays.sort(replaceStrings);
	}
	
	public void setActiveEditor(IAction action, IEditorPart ed) {
		editor = ed instanceof ITextEditor ? (ITextEditor)ed : null;
		action.setEnabled(isEnable());
	}

	public void selectionChanged(IAction action, ISelection sel) {
		selection = sel instanceof ITextSelection ? (ITextSelection)sel : null;
		action.setEnabled(isEnable());
	}
	
	boolean isEnable(){
		if(editor != null && selection != null){
			String text = selection.getText();
			if(text != null){
				for (int i = 0; i < replaceStrings.length; i++) {
					if(text.indexOf(replaceStrings[i]) != -1){
						return true;
					}
				}
			}
		}
		return false;
	}
	
	public void run(IAction action) {
		if(isEnable()){
			IDocument doc = editor.getDocumentProvider().getDocument(editor.getEditorInput());
			try {
				doReplace(doc, selection);
			} catch (BadLocationException e) {
				WebpubUIPlugin.handleException(e);
			}
		}
	}
	
	protected void doReplace(IDocument doc, ITextSelection sel) throws BadLocationException{
		doc.replace(
			sel.getOffset(),
			sel.getLength(),
			HTMLUtilities.unescape(sel.getText()) );
	}

}
