/*
 * $Id: TemplateResearchAction.java,v 1.1 2004/01/17 12:08:06 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import com.narucy.webpub.core.template.TemplateManager;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * 
 */
public class TemplateResearchAction implements IWorkbenchWindowActionDelegate {

	IWorkbenchWindow window;
	ISelection selection;

	public void dispose() {
	}

	public void init(IWorkbenchWindow window) {
		this.window = window;
	}

	public void run(IAction action) {
		IRunnableWithProgress operation = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
				research(monitor);
			}
		};
		try{
			new ProgressMonitorDialog(window.getShell()).run(true, true, operation);	
		}
		catch(InvocationTargetException e){
			e.getCause().printStackTrace();
			handleException(e);
		}
		catch(InterruptedException e){
			handleException(e);
		}
	}
	
	public void research(IProgressMonitor monitor){
		monitor.beginTask("Search HTML doucment templates", 1);
		try{
			IProject project = getProjectAsSelection();
			if(project == null){
				return;
			}
			TemplateManager manager = (TemplateManager)project.getAdapter(TemplateManager.class);
			manager.researchAll(new SubProgressMonitor(monitor, 1) );
		} catch (CoreException e) {
			handleException(e);
		} finally{
			monitor.done();
		}
	}
	
	IProject getProjectAsSelection(){
		if(selection instanceof IStructuredSelection){
			IStructuredSelection ss = (IStructuredSelection)selection;
			Object[] objs = ss.toArray();
			for (int i = 0; i < objs.length; i++) {
				Object o = objs[i];
				if(o instanceof IResource){
					return ((IResource)o).getProject();
				}
			}
		}
		return null;
	}

	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
		action.setEnabled(getProjectAsSelection() != null);
	}

	protected void handleException(Exception e){
		e.printStackTrace();
		IStatus status = new Status(
			IStatus.ERROR,
			WebpubUIPlugin.ID_PLUGIN,
			0,
			e.getMessage(),
			e);
		
		ErrorDialog.openError(
			window.getShell(),
			"Publish Error",
			"Error occase in publishing a html documents or coping files", status);
	}


	void p(Object o) {
		System.out.println(getClass() + ":" + o);
	}

}
