/*
 * $Id: RepublishAction.java,v 1.2 2004/01/18 07:35:55 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * 
 */
public class RepublishAction implements IWorkbenchWindowActionDelegate {

	IWorkbenchWindow window;
	ISelection selection;

	IWorkspaceRunnable republishProc = new IWorkspaceRunnable() {
		public void run(IProgressMonitor m) throws CoreException {
			IResource[] resources = getSelectedResource();
			m.beginTask("Touch resource", resources.length * 2);
			try{
				for (int i = 0; i < resources.length && !m.isCanceled(); i++) {
					IResource r = resources[i];
					r.touch(new SubProgressMonitor(m, 1));
					r.getProject().build(IncrementalProjectBuilder.INCREMENTAL_BUILD, new SubProgressMonitor(m, 1));
				}
			}finally{
				m.done();
			}
		}
	};

	public void init(IWorkbenchWindow window) {
		this.window = window;
	}

	public void run(IAction act) {
		IRunnableWithProgress operation = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
				try {
					ResourcesPlugin.getWorkspace().run(republishProc, monitor);
				} catch (CoreException e) {
					WebpubUIPlugin.handleException(e);
				}
			}
		};
		try{
			if(window != null){
				window.run(true, true, operation);
			}else{
				operation.run(new NullProgressMonitor());
			}
		}
		catch(InvocationTargetException e){
			WebpubUIPlugin.handleException(e);
		}catch(InterruptedException e){
			WebpubUIPlugin.handleException(e);
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
		action.setEnabled(getSelectedResource().length > 0);
	}

	IResource[] getSelectedResource(){
		ArrayList resources = new ArrayList();
		if(selection instanceof IStructuredSelection && !selection.isEmpty()){
			Object[] items = ((IStructuredSelection)selection).toArray();
			for (int i = 0; i < items.length; i++) {
				if(items[i] instanceof IResource){
					resources.add(items[i]);
				}
			}
		}
		return (IResource[])resources.toArray(new IResource[resources.size()]);
	}
	
	public void dispose() {
	}

}
