/*
 * $Id: OpenNewWebProjectWizardAction.java,v 1.1 2004/01/17 12:08:05 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.*;

import com.narucy.webpub.ui.wizards.NewWebProjectWizard;

public class OpenNewWebProjectWizardAction implements IWorkbenchWindowActionDelegate {

	IWorkbenchWindow window = null;
	Wizard lastOpendWizard = null;

	public void init(IWorkbenchWindow window) {
		this.window = window;
	}

	public void openWizard(Wizard wizard){
		if (wizard instanceof IWorkbenchWizard) {
			ISelection sel = window.getSelectionService().getSelection();
			
			IWorkbenchWizard wiz = (IWorkbenchWizard)wizard;
			wiz.init(
				window.getWorkbench(),
				(sel instanceof IStructuredSelection) ? (IStructuredSelection)sel : null);
		}
		Shell shell = wizard.getShell();
		WizardDialog dialog= new WizardDialog(shell, wizard);
		dialog.create();
		dialog.open();
		
		lastOpendWizard = wizard;
	}

	public void run(IAction action) {
		openWizard( new NewWebProjectWizard() );
	}

	protected void handleException(Exception e) {
		throw new RuntimeException(e.toString());
	}

	public void dispose() {
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

	public Wizard getLastOpendWizard() {
		return lastOpendWizard;
	}

}
