/*
 * $Id: OpenEditorFromURLAction.java,v 1.1 2004/01/17 12:08:05 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PartInitException;

import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * 
 */
public class OpenEditorFromURLAction extends Action {

	IFile openFile;

	public OpenEditorFromURLAction() {
		super("Open Editor", WebpubUIPlugin.getDefault().getImageDescriptor("ctool16/open_editor.gif"));
		setToolTipText("Open Editor");
		
		setOpenFile(null);
	}
	
	public void setOpenFile(IFile openFile){
		this.openFile = openFile;
		setEnabled(openFile != null);
	}
	
	public IFile getOpenFile() {
		return openFile;
	}
	
	public void run() {
		if( openFile != null){
			try {
				WebpubUIPlugin.getActivePage().openEditor(openFile);
			} catch (PartInitException e) {
				WebpubUIPlugin.handleException(e);
			}
		}
		
		
	}


}
