/*
 * $Id: ModifyElementAction.java,v 1.1 2004/01/17 12:08:06 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.*;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

import com.narucy.webpub.ui.HTParser;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.wizards.EditElementWizard;

/**
 * InsertTagAction
 */
public class ModifyElementAction implements IEditorActionDelegate {

	ITextEditor editor = null;
	
	public ModifyElementAction() {
	}
	
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		if( targetEditor instanceof ITextEditor ){
			editor = (ITextEditor)targetEditor;
		}
	}

	public void run(IAction action) {
		try{
			IDocument doc =  editor.getDocumentProvider().getDocument(editor.getEditorInput());
			ITextSelection sel = HTParser.getElementRange(doc, ((ITextSelection)editor.getSelectionProvider().getSelection()).getOffset() );
			editor.getSelectionProvider().setSelection(sel);
			
			String text = sel.getText();
			if( text == null){
				throw new BadLocationException("Invalid text selection, can't choose element.");
			}
			String elemName = HTParser.chooseElementName(text);
			
			WizardDialog wizDialog =
				new WizardDialog(
					editor.getSite().getShell(),
					new EditElementWizard(editor, elemName) ){
			
				protected int getShellStyle() {
					return super.getShellStyle() | SWT.RESIZE;
				}
			};
			
			wizDialog.open();
		} catch(BadLocationException e){
			ErrorDialog dialog = new ErrorDialog(
				editor.getSite().getShell(),
				"Text Selection Error",
				"Invalid element hierarchy?",
				new Status(IStatus.WARNING, WebpubUIPlugin.ID_PLUGIN, IStatus.OK, e.getLocalizedMessage(), e),
				IStatus.WARNING);
			dialog.open();
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

}
