/*
 * $Id: InsertNewElementAction.java,v 1.1 2004/01/17 12:08:05 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

import com.narucy.webpub.ui.wizards.EditElementWizard;

/**
 * InsertTagAction
 */
public class InsertNewElementAction implements IEditorActionDelegate {

	ITextEditor targetEditor = null;

	public InsertNewElementAction() {
	}
	
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		if(targetEditor instanceof ITextEditor){
			this.targetEditor = (ITextEditor)targetEditor;
		}
	}

	public void run(IAction action) {
	
		WizardDialog wizDialog =
			new WizardDialog(
				targetEditor.getSite().getShell(),
				new EditElementWizard(targetEditor, null) ){

			protected int getShellStyle() {
				return super.getShellStyle() | SWT.RESIZE;
			}
		};
		
		wizDialog.open();
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

}
