/*
 * $Id: WebpubUIPlugin.java,v 1.1 2004/01/17 12:08:09 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.*;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.*;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.core.publish.PublishDescriptionFactory;
import com.narucy.webpub.core.toc.Topic;

/**
 * The main plugin class.
 */
public class WebpubUIPlugin extends AbstractUIPlugin {

	// The shared instance.
	static WebpubUIPlugin plugin;
	
	// constants.
	final public static String
		ID_PLUGIN = "com.narucy.webpub",
		HT_PREVIEW_LINK_WITH_EDITOR = "ht_preview_link_with_editor",
		HT_PREVIEW_EXTENSIONS = "ht_preview_extensions",
		HT_EDITOR_DISPLAYED_TAB_WIDTH = "ht_editor_displayed_tab_editor",
		HT_EDITOR_WORDWRAP = "ht_editor_wordwrap",
		RUBY_INTERPRETER_LOCATION = "ruby_interpreter_location",
		IGNORE_PUBLISH_FILE_PATTERNS = "ignore_publish_file_pattern",
		HT_EDITOR_COLOR_BACKGROUND = "ht_editor_color_background",
		HT_EDITOR_COLOR_DEFAULT = "ht_editor_color_default",
		HT_EDITOR_COLOR_TAG = "ht_editor_color_tag",
		HT_EDITOR_COLOR_ATTR = "ht_editor_color_attr",
		HT_EDITOR_COLOR_COMMENT = "ht_editor_color_comment",
		HT_EDITOR_COLOR_ERB = "ht_editor_color_erb",
		HT_EDITOR_COLOR_PROCESSOR = "ht_editor_color_processor",
		HT_EDITOR_CONTENT_ASSIST = "ht_editor_content_assist",
		HT_EDITOR_CONTENT_ASSIST_DELAY = "ht_editor_content_assist_delay",
		TOCVIEW_FILES = "tocview_files",
		PUBLISH_CONSOLE_CHARSET = "publish_console_charset";

	WorkbenchTocAdapterFactory tocElementAdapterFactory = new WorkbenchTocAdapterFactory();

	//Resource bundle.
	ResourceBundle resourceBundle;
	URL imageBaseUrl;
	
	public WebpubUIPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		try {
			resourceBundle= ResourceBundle.getBundle("webpubui");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
		
		try {
			imageBaseUrl = new URL(
				WebpubUIPlugin.getDefault().getDescriptor().getInstallURL(), "icons/full/");
		} catch (MalformedURLException e) {
			WebpubUIPlugin.handleException(e);
		}
	}

	public static WebpubUIPlugin getDefault() {
		return plugin;
	}
	
	public static URL getResource(String path){
		return getDefault().getDescriptor().find(new Path(path));
	}

	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	
	public static void handleException(Exception e){
		e.printStackTrace();
		IStatus status;
		if( e instanceof CoreException){
			status = ((CoreException)e).getStatus();
		}else{
			status = new Status(IStatus.ERROR, ID_PLUGIN, IStatus.OK, "Plug-in error", e);
		}
		getDefault().getLog().log(status);
	}
	
	/**
	 * Initializes a preference store with default preference values 
	 * for this plug-in.
	 * 
	 * @param store the preference store to fill
	 */
	protected void initializeDefaultPreferences(IPreferenceStore store) {
		store.setDefault(
			IGNORE_PUBLISH_FILE_PATTERNS,
			"CVS .publish");

		IPath rubyPath = WebpubPlugin.findInitialInterpreter();
		store.setDefault(
			RUBY_INTERPRETER_LOCATION, rubyPath != null ?
				rubyPath.toString() :
				"c:/ruby/bin/ruby.exe");
		
		// initialize preview preference
		store.setDefault( HT_PREVIEW_LINK_WITH_EDITOR, false);
		store.setDefault( HT_PREVIEW_EXTENSIONS,
			"html htm xml jpeg jpg gif png rd svg");

		// initialize html editor preference
		store.setDefault(HT_EDITOR_DISPLAYED_TAB_WIDTH, 4);
		store.setDefault(HT_EDITOR_WORDWRAP, false);
		
		store.setDefault(HT_EDITOR_COLOR_BACKGROUND, "255,255,255");
		store.setDefault(HT_EDITOR_COLOR_DEFAULT, "0,0,0");
		store.setDefault(HT_EDITOR_COLOR_TAG, "0,0,127");
		store.setDefault(HT_EDITOR_COLOR_COMMENT, "0,127,0");
		store.setDefault(HT_EDITOR_COLOR_ERB, "127,127,127");
		store.setDefault(HT_EDITOR_COLOR_ATTR, "127,0,0");
		store.setDefault(HT_EDITOR_COLOR_PROCESSOR, "127,0,127");

		store.setDefault(HT_EDITOR_CONTENT_ASSIST, true);
		store.setDefault(HT_EDITOR_CONTENT_ASSIST_DELAY, 500);
		
		store.setDefault(TOCVIEW_FILES, "");
		store.setDefault(PUBLISH_CONSOLE_CHARSET, "UTF-8");
		
		store.addPropertyChangeListener(new IPropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent event) {
				String propName = event.getProperty();
				if(propName.equals(IGNORE_PUBLISH_FILE_PATTERNS) ){
					String[] patterns = StringConverter.asArray((String)event.getNewValue());
					PublishDescriptionFactory.getInstance().setIgnorePatterns(patterns);
				}else if(propName.equals(RUBY_INTERPRETER_LOCATION)){
					refreshInterpreterLocation();
				}
			}
		});
		
		refreshInterpreterLocation();
	}

	void refreshInterpreterLocation(){
		IPreferenceStore store = getPreferenceStore();
		String location = store.getString(RUBY_INTERPRETER_LOCATION);
		if( location != null && location.length() > 0){
			WebpubPlugin.getDefault().setRubyCommandPath(new Path(location));
		}
	}
	
	public static String join(String[] vals){
		StringBuffer buff = new StringBuffer();
		for (int i = 0; i < vals.length; i++) {
			buff.append(vals[i]);
			if(i != vals.length-1){
				buff.append(' ');
			}
		}
		return buff.toString();
	}
	
	public ImageDescriptor getImageDescriptor(String iconPath){
		try {
			URL url = new URL(imageBaseUrl, iconPath);
			return ImageDescriptor.createFromURL(url);
		} catch (MalformedURLException e) {
		}
		return null;
	}
	
	/*
	public Image getImage(String iconPath){
		if(imageRegistory == null || imageRegistory.getDescriptor(iconPath) == null){
			getImageDescriptor(iconPath); // regist image descriptor.
		}
		return imageRegistory.get(iconPath);
	}
	*/

	/**
	 * Utilities method for workbench ui mounting.
	 */
	public static IWorkbenchWindow getActiveWorkbenchWindow(){
		return getDefault().getWorkbench().getActiveWorkbenchWindow();
	}
	
	/**
	 * Utilities method for workbench ui mounting.
	 */
	public static IWorkbenchPage getActivePage(){
		return getActiveWorkbenchWindow().getActivePage();
	}

	/**
	 * Utilities method for workbench ui mounting.
	 */
	public static IViewPart findView(String id){
		IWorkbenchPage page = WebpubUIPlugin.getActivePage();
		if( page != null){
			return page.findView(id);
		}
		return null;
	}
	
	public String getRDTSelectedInterpreterLocation(){
		try{
			Plugin plugin = Platform.getPlugin("org.rubypeople.rdt.launching");
			Class klass = plugin.getClass().getClassLoader().loadClass("org.rubypeople.rdt.internal.launching.RubyRuntime");
			Method method = klass.getDeclaredMethod("getDefault", new Class[0]);
			Object rubyRuntime = method.invoke(klass, new Object[0]);
			Method getSelectedInterpreterMethod = rubyRuntime.getClass().getDeclaredMethod("getSelectedInterpreter", new Class[0]);
			Object rubyInterpreter = getSelectedInterpreterMethod.invoke(rubyRuntime, new Object[0]);
			Method getLocationMethod = rubyInterpreter.getClass().getDeclaredMethod("getCommand", new Class[0]);
			return (String)getLocationMethod.invoke(rubyInterpreter, new Object[0]);
		}catch(Exception e){
		}
		return null;
	}

	public void startup() throws CoreException {
		IAdapterManager manager= Platform.getAdapterManager();
		manager.registerAdapters(tocElementAdapterFactory, Topic.class);
	}

	public void shutdown() throws CoreException {
		IAdapterManager manager= Platform.getAdapterManager();
		manager.unregisterAdapters(tocElementAdapterFactory);
	}
	
	void p(Object o) {
		System.out.println(getClass() + ":" + o);
	}

}
