/*
 * $Id: WebResourcesDecorator.java,v 1.1 2004/01/17 12:08:10 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui;

import java.util.HashMap;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.*;
import org.eclipse.core.runtime.Preferences.PropertyChangeEvent;
import org.eclipse.jface.viewers.*;

import com.narucy.webpub.core.WebProject;

/**
 * 
 */
public class WebResourcesDecorator extends LabelProvider implements ILightweightLabelDecorator {

	final public static String
		ID_DECORATOR = "com.narucy.webpub.webResourceDecorator";
	
	static String[] folderKeys = {
		WebProject.KEY_HTSOURCES_FOLDER,
		WebProject.KEY_SCRIPTS_FOLDER,
		WebProject.KEY_PUBLISH_FOLDER,
	};
	
	HashMap listenersCache = new HashMap();
	
	static int getKeyIndex(String k){
		for(int i=0; i<folderKeys.length; i++){
			if(folderKeys[i].equals(k)){
				return i;
			}
		}
		return -1;
	}
	
	public void decorate(Object element, IDecoration decoration) {
		try{
			IResource res = getResource(element);
			final WebProject webProj = res != null && res.getProject() != null && res.isAccessible() ?
				(WebProject)res.getProject().getNature(WebProject.ID_NATURE) :
				null;
				
			if(webProj != null){
				Object[] entry = (Object[])listenersCache.get(webProj);
				if(entry == null){
					Preferences.IPropertyChangeListener listener = new Preferences.IPropertyChangeListener() {
						public void propertyChange(PropertyChangeEvent event) {
							refresh(webProj, event.getProperty());
						}
					};
					webProj.addPropertyChangeListener(listener);
					entry = new Object[4];
					entry[0] = listener;
					listenersCache.put(webProj, entry);
				}
			}
			
			Object[] webProjects = listenersCache.keySet().toArray();
			for (int i = 0; i < webProjects.length; i++) {
				WebProject wp = (WebProject)webProjects[i];
				Object[] entry = (Object[])listenersCache.get(wp);
				if ( wp.getFolder(WebProject.KEY_HTSOURCES_FOLDER).equals(res)){
					decoration.addOverlay(WebpubUIPlugin.getDefault().getImageDescriptor("ovr16/htsource_folder_ovr.gif"));
					entry[1] = res;
				} else if (wp.getFolder(WebProject.KEY_SCRIPTS_FOLDER).equals(res) ){
					decoration.addOverlay(WebpubUIPlugin.getDefault().getImageDescriptor("ovr16/scripts_folder_ovr.gif"));
					entry[2] = res;
				} else if( wp.getFolder(WebProject.KEY_PUBLISH_FOLDER).equals(res) ){
					decoration.addOverlay(WebpubUIPlugin.getDefault().getImageDescriptor("ovr16/publish_folder_ovr.gif"));
					entry[3] = res;
				}
			}
		}catch(CoreException e){
			WebpubUIPlugin.handleException(e);
		}
	}
	
	void refresh(WebProject wp, String key){
		Object[] entry = (Object[])listenersCache.get(wp);
		if(entry == null){
			return;
		}
		
		IContainer container = getCachedContainer(wp, key);
		if(container != null){
			fireLabelProviderChanged(new LabelProviderChangedEvent(this, container));
		}
		
		container = wp.getFolder(key);
		if(container != null){
			fireLabelProviderChanged(new LabelProviderChangedEvent(this, container));
		}
	}
	
	IContainer getCachedContainer(WebProject wp, String key){
		Object[] entry = (Object[])listenersCache.get(wp);
		int index = getKeyIndex(key);
		if(index != -1 && entry[index+1] != null){
			fireLabelProviderChanged(new LabelProviderChangedEvent(this, entry[index+1]));
		}
		return null;
	}
	
	static IResource getResource(Object obj) {
		if (obj instanceof IResource) {
			return (IResource) obj;
		}
		if (obj instanceof IAdaptable) {
			return (IResource) ((IAdaptable) obj).getAdapter(IResource.class);
		}
		return null;
	}

	public void dispose() {
		Object[] webProjects = listenersCache.keySet().toArray();
		for (int i=0; i<webProjects.length; i++) {
			WebProject wp = (WebProject)webProjects[i];
			
			Object[] entry = (Object[])listenersCache.remove(wp);
			wp.removePropertyChangeListener( (Preferences.IPropertyChangeListener)entry[0] );
		}
	}

}


