/*
 * $Id: WebResourceSelectionAdapter.java,v 1.1 2004/01/17 12:08:10 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.wizard.WizardPage;

import com.narucy.webpub.core.WebResourceSelectionListener;

/**
 * 
 */
public abstract class WebResourceSelectionAdapter implements WebResourceSelectionListener {

	final WizardPage page;
	
	public WebResourceSelectionAdapter(WizardPage page){
		this.page = page;
	}

	public void statusChanged(IStatus status) {
		int serverity = status.getSeverity();
		if( serverity == IStatus.ERROR){
			page.setErrorMessage(status.getMessage());
		}else{
			page.setErrorMessage(null);
			switch (status.getSeverity()) {
				case IStatus.WARNING:
					page.setMessage(status.getMessage(), IMessageProvider.WARNING);
					break;
				default:
					page.setMessage(null, IMessageProvider.NONE);
			}
		}
	}

}
