/*
 * $Id: JFaceUtilities.java,v 1.1 2004/01/17 12:08:10 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.preference.*;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/**
 * 
 */
public class JFaceUtilities {

	private JFaceUtilities() {}

	public static IPreferencePage findPreferencePage(Shell sh, Class klass){
		PreferenceDialog[] dialogs = getPreferenceDialogs(sh.getDisplay());
		for (int i = 0; i < dialogs.length; i++) {
			PreferenceDialog dialog = dialogs[i];
			Object[] list = dialog.getPreferenceManager().getElements(PreferenceManager.POST_ORDER).toArray();
			for (int j = 0; j < list.length; j++) {
				IPreferencePage page = ((IPreferenceNode) list[j]).getPage();
				if(page.getClass().equals(klass)){
					return page;
				}
			}
		}
		return null;
	}
	
	public static IWizardContainer[] getWizardContainers(Display disp){
		ArrayList list = new ArrayList();
		Window[] windows = getAllWindows(disp);
		for (int i = 0; i < windows.length; i++) {
			Window win = windows[i];
			if (win instanceof IWizardContainer) {
				list.add(win);
			}
		}
		return (IWizardContainer[])list.toArray(new IWizardContainer[list.size()]);
	}

	public static PreferenceDialog[] getPreferenceDialogs(Display disp) {
		ArrayList list = new ArrayList();
		Window[] windows = getAllWindows(disp);
		for (int i = 0; i < windows.length; i++) {
			Window win = windows[i];
			if (win instanceof PreferenceDialog) {
				list.add(win);
			}
		}
		return (PreferenceDialog[]) list.toArray(new PreferenceDialog[list.size()]);
	}

	public static Window[] getAllWindows(Display disp) {
		ArrayList windows = new ArrayList();
		Shell[] shells = disp.getShells();
		for (int i = 0; i < shells.length; i++) {
			Shell shell = shells[i];
			Object data = shell.getData();
			if (data instanceof Window) {
				windows.add(data);
			}
		}
		return (Window[]) windows.toArray(new Window[windows.size()]);
	}


	final public static IInputValidator FILE_EXTENSION_VALIDATOR = new IInputValidator() {
		char[] invalidChars = "\\/:;*,?<>| \t\r\n".toCharArray();
		
		public String isValid(String newName) {
			for (int i = 0; i < invalidChars.length; i++) {
				char ch = invalidChars[i];
				if(newName.indexOf(ch) != -1){
					return "Invalid char code \"" + ch + "\"";
				}
			}
			if (newName.length() > 0 && newName.charAt(0) == '.'){
				return "Not need to specify first char \".\"";
			}
			return null;
		}
	};

}
