package com.narucy.webpub.linkcheck.ui;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.*;
import org.eclipse.debug.core.*;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;
import org.eclipse.ui.part.FileEditorInput;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.linkcheck.core.LinkCheckConfigurationFactory;
import com.narucy.webpub.linkcheck.core.LinkCheckConstants;

/**
 * LinkCheckShortcut
 */
public class LinkCheckShortcut implements ILaunchShortcut, LinkCheckConstants {

	final static List EMPTY_LIST = new ArrayList();

	LinkCheckConfigurationFactory launchFactory = new LinkCheckConfigurationFactory();

	public void launch(IEditorPart editor, String mode)  {
		IEditorInput input = editor.getEditorInput();
		if(input instanceof IFileEditorInput){
			launch(new StructuredSelection(((FileEditorInput)input).getFile()), mode);
		}else{
			MessageDialog.openError(
				editor.getSite().getShell(),
				"Can not launch link checker",
				"Current editor input is not file.");
		}
	}

	public void launch(ISelection selection, String mode)  {
		if (selection.isEmpty() || !(selection instanceof IStructuredSelection) ) {
			return;
		}
		try{
			ILaunchConfiguration conf = getLaunchConfiguration((IStructuredSelection)selection);
			conf.launch(mode, new NullProgressMonitor());
		}catch(CoreException e){
			WebpubPlugin.handleException(e);
		}
	}
	
	ILaunchConfiguration getLaunchConfiguration(IStructuredSelection selection) throws CoreException{
		ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
		ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(ID_LINKCHECK_LAUNCH_CONFIGURATION);

		Object[] rs = selection.toArray();
		ArrayList resourcesArray = new ArrayList();
		for (int i = 0; i < rs.length; i++) {
			Object r = rs[i];
			if(r instanceof IAdaptable){
				r = ((IAdaptable)r).getAdapter(IResource.class);
			}
			if(r instanceof IResource){
				resourcesArray.add(r);
			}
		}
		
		IResource[] resources = (IResource[]) resourcesArray.toArray(new IResource[resourcesArray.size()]);
		// if web project selected when changes target.
		for (int i = 0; i < resources.length; i++) {
			if(resources[i] instanceof IProject){
				WebProject wp = (WebProject) ((IProject)resources[i]).getNature(WebProject.ID_NATURE);
				if(wp != null){
					resources[i] = wp.getFolder(WebProject.KEY_PUBLISH_FOLDER);
				}
			}
		}
		
		// if not registed state launch configuration, create launch configuration.
		// if created when share created launch configuration.
		ILaunchConfigurationWorkingCopy wc = launchFactory.createLaunchConfiguration(resources, true);
		List wcCheckFiles = wc.getAttribute(ATTR_CHECK_RESOURCES, EMPTY_LIST);
		
		ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(type);
		for (int i = 0; i < configs.length; i++) {
			ILaunchConfiguration c = configs[i];
			
			List checkFiles = c.getAttribute(ATTR_CHECK_RESOURCES, EMPTY_LIST);
			if(checkFiles.size() != 0 && checkFiles.equals(wcCheckFiles)){
				return c;
			}
		}
		
		return wc.doSave();
	}
	
	void p(Object o) {
		System.out.println(getClass() + ":" + o);
	}

}
