/*
 * $Id: HTTPLinkCheckLaunchConfigurationTab.java,v 1.3 2004/01/17 11:50:30 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.linkcheck.ui;

import java.util.ArrayList;
import java.util.Arrays;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

import com.narucy.webpub.debug.WebpubDebugPlugin;
import com.narucy.webpub.linkcheck.core.LinkCheckConstants;

/**
 * 
 */
class HTTPLinkCheckLaunchConfigurationTab extends AbstractLaunchConfigurationTab implements LinkCheckConstants {

	final static ArrayList EMPTY_LIST = new ArrayList();

	final static String[] ERRORS = {
		"400","Bud Request",
		"401","Unauthorized",
		"402","Payment Required",
		"403","Forbidden",
		"404","Not Found",
		"405","Method Not Allowed",
		"406","Not Acceptable",
		"407","Proxy Authentication Required",
		"408","Request Timeout",
		"409","Conflict",
		"410","Gone",
		"411","Length Required",
		"412","Precondition Failed",
		"413","Required Entry Too Large",
		"415","Unsupported Media Type",
		"500","Inetrnal Sever Error",
		"501","Not Implemented",
		"502","Bad Gateway",
		"503","Service Unavailable",
		"504","Gateway Timeout",
		"505","HTTP Version Not Supported",
	};

	final static String[] DEFAULT_SELECTED = new String[]{
		"404", "500",  "501", "502", "503", "504", "505", 
	};

	Image imageIcon = null;
	CheckboxTableViewer codesViewer;

	Button checkAllButton;

	SelectionListener buttonListener = new SelectionListener() {
		public void widgetSelected(SelectionEvent e) {
			if(e.widget == checkAllButton){
				handleSelectAll();
				getLaunchConfigurationDialog().updateButtons();
			}
		}
		public void widgetDefaultSelected(SelectionEvent arg0) {}
	};
	
	void handleSelectAll(){
		codesViewer.setAllChecked(true);
	}

	public void createControl(Composite parent) {
		imageIcon = WebpubDebugPlugin.getImageDescriptor("ctool16/hticon.gif").createImage();
		
		Composite base = new Composite(parent, SWT.NONE);
		base.setLayout(new GridLayout(1, true));
		
		new Label(base, SWT.NONE).setText("&Catch Errors:");
		createCodeListControl(base)
			.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		setControl(base);
	}
	
	Control createCodeListControl(Composite parent){
		Composite base = new Composite(parent, SWT.NONE);
		base.setLayout(new GridLayout(2, false));
		
		codesViewer = CheckboxTableViewer.newCheckList(base, SWT.V_SCROLL | SWT.H_SCROLL | SWT.BORDER);
		codesViewer.getControl().setLayoutData(new GridData(GridData.FILL_BOTH));
		
		codesViewer.setColumnProperties(new String[]{"code", "description"});
		codesViewer.setLabelProvider(new ITableLabelProvider() {
			public Image getColumnImage(Object element, int columnIndex) {
				return null;
			}

			public String getColumnText(Object element, int columnIndex) {
				if(columnIndex == 0){
					return (String)element;
				}
				if(columnIndex == 1){
					for(int i=0; i<ERRORS.length; i+=2){
						if(ERRORS[i].equals(element)){
							return ERRORS[i+1];
						}
					}
				}
				return null;
			}

			public void addListener(ILabelProviderListener listener) {
			}

			public void dispose() {}

			public boolean isLabelProperty(Object element, String property) {
				return property.equals("code") || property.equals("description");
			}

			public void removeListener(ILabelProviderListener listener) {}
		});
		codesViewer.setContentProvider(new ArrayContentProvider());
		String[] codes = new String[ERRORS.length / 2];
		for(int i=0, j=0; i<ERRORS.length; i+=2, j++){
			codes[j] = ERRORS[i];
		}
		Table t = codesViewer.getTable();
		t.setLinesVisible(true);
		t.setHeaderVisible(true);
		
		new TableColumn(t, SWT.LEFT).setText("Code");
		new TableColumn(t, SWT.LEFT).setText("Description");

		codesViewer.setInput(codes);
		codesViewer.refresh();
		TableColumn[] cols = t.getColumns();
		for (int i = 0; i < cols.length; i++) {
			cols[i].pack();
		}
		
		checkAllButton = createButton(base, "Check &All");
		
		codesViewer.addCheckStateListener(new ICheckStateListener() {
			public void checkStateChanged(CheckStateChangedEvent event) {
				checkAllButton.setEnabled( codesViewer.getCheckedElements().length < ERRORS.length);
				setDirty(true);
				getLaunchConfigurationDialog().updateButtons();
			}
		});
		
		return base;
	}
	
	Button createButton(Composite parent, String name){
		Button button = new Button(parent, SWT.PUSH);
		button.setText(name);
		button.addSelectionListener(buttonListener);
		
		button.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.VERTICAL_ALIGN_BEGINNING));
		return button;
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
		wc.setAttribute(ATTR_HTTP_CODE, Arrays.asList(DEFAULT_SELECTED));
	}

	public void initializeFrom(ILaunchConfiguration conf) {
		try {
			codesViewer.setCheckedElements(conf.getAttribute(ATTR_HTTP_CODE, Arrays.asList(DEFAULT_SELECTED)).toArray());
		} catch (CoreException e) {
			WebpubDebugPlugin.handleException(e);
		}
	}

	public void performApply(ILaunchConfigurationWorkingCopy wc) {
		Object[] codes = codesViewer.getCheckedElements();
		wc.setAttribute(ATTR_HTTP_CODE, Arrays.asList(codes));
	}

	public String getName() {
		return "&Http";
	}

	public Image getImage() {
		return imageIcon;
	}

	public void dispose() {
		if(imageIcon != null){
			imageIcon.dispose();
		}
		super.dispose();
	}

}
