/*
 * $Id: LinkCheckConfigurationDelegate.java,v 1.1 2004/01/17 16:49:33 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.linkcheck.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.debug.core.*;
import org.eclipse.debug.core.model.*;

import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.debug.WebpubDebugPlugin;

/**
 * 
 */
public class LinkCheckConfigurationDelegate implements ILaunchConfigurationDelegate, LinkCheckConstants {

	final static List EMPTY_LIST = new ArrayList();
	
	String checkScriptPath = WebpubDebugPlugin.getDefault().find(new Path("scripts/bin/checklink.rb")).getFile();
	int sleepTime = 1000;
	
	public LinkCheckConfigurationDelegate() {
	}
	
	String renderCommandArguments(ILaunchConfiguration config) throws CoreException{
		StringBuffer buff = new StringBuffer(checkScriptPath);
		
		List regexps = config.getAttribute(ATTR_IGNORE_REGEXPS, EMPTY_LIST);
		if(regexps.size() > 0){
			buff.append(" --ingore_link_regexp ");
			distListWithComma(buff, regexps);
		}
		
		List exts = config.getAttribute(ATTR_EXTENSIONS, EMPTY_LIST);
		if(exts.size() > 0){
			buff.append(" --exts ");
			distListWithComma(buff, exts);
		}
		
		List files = config.getAttribute(ATTR_CHECK_RESOURCES, EMPTY_LIST);
		if(files.size() > 0){
			buff.append(" --files ");
			distListWithComma(buff, files);
		}
		
		List httpCodes = config.getAttribute(ATTR_HTTP_CODE, EMPTY_LIST);
		if(httpCodes.size() > 0){
			buff.append(" --http_error_codes ");
			distListWithComma(buff, httpCodes);
		}
		return buff.toString();
	}
	
	static void distListWithComma(StringBuffer buff, List ls){
		for(int i=0, len = ls.size(); i<len; i++){
			buff.append((String)ls.get(i));
			if(i != len-1){
				buff.append(',');
			}
		}
	}
	
	public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor moni) throws CoreException {
		final IProgressMonitor monitor =
			(moni != null) ? moni : new NullProgressMonitor();
		
		try {
			monitor.beginTask("Starting link check", IProgressMonitor.UNKNOWN);
			// delete markers
			List resources = config.getAttribute(ATTR_CHECK_RESOURCES, new ArrayList());
			
			final ArrayList livingResources = new ArrayList();
			IWorkspace workspace = ResourcesPlugin.getWorkspace();
			IWorkspaceRoot root = workspace.getRoot();
			for(int i=0; i<resources.size(); i++){
				Path path = new Path((String)resources.get(i));
				IResource r = root.getContainerForLocation(path);
				if(!r.isAccessible()){
					r = root.getFileForLocation(path);
				}
				if(r.isAccessible()){
					livingResources.add(r);
				}
			}
			workspace.run(new IWorkspaceRunnable() {
				public void run(IProgressMonitor monitor) throws CoreException {
					deleteMarkers((IResource[])livingResources.toArray(new IResource[livingResources.size()]));
				}
			}, new SubProgressMonitor(monitor, 1) );
			
			
			// invoke interpreter.
			String args = renderCommandArguments(config);
			Process nativeProcess = WebpubPlugin.getDefault().rubyExec(args, null);
			final IProcess process = DebugPlugin.newProcess(launch, nativeProcess, "Link Checker");
			
			//// parseing result.
			IStreamsProxy proxy = process.getStreamsProxy();
			final CheckResoutMonitor resultMonitor = new CheckResoutMonitor(proxy);
			
			// read result and notify progress to monitor.
			final boolean background = config.getAttribute(ATTR_BACKGROUND, false);
			
			Runnable run = new Runnable() {
				public void run() {
					while(!monitor.isCanceled() && !process.isTerminated()){
						try {
							Thread.sleep(sleepTime);
						} catch (InterruptedException e) {
							WebpubDebugPlugin.handleException(e);
						}
						IFile chkFile = resultMonitor.getCurrentCheckFile();
						int finishedCount = resultMonitor.getFinishedFileCount();
						if(!background && chkFile != null){
							monitor.setTaskName("Checking " + chkFile.getFullPath());
						}
					}
				}
			};
			if(background){
				new Thread(run).start();
			}else{
				run.run();
			}
		} catch (IOException e) {
			WebpubDebugPlugin.handleException(e);
		} finally{
			monitor.done();
		}
	}
	
	static void deleteMarkers(IResource[] rs) throws CoreException{
		for (int i = 0; i < rs.length; i++) {
			IResource r = rs[i];
			if(r.isAccessible()){
				deleteMarker(r);
				if(r instanceof IContainer){
					deleteMarkers( ((IContainer)r).members() );
				}
			}
		}
	}

	static void deleteMarker(IResource res) throws CoreException {
		IMarker[] markers = res.findMarkers(null, true, IResource.DEPTH_ZERO);
		for (int i = 0; i < markers.length; i++) {
			IMarker m = markers[i];
			if(Boolean.TRUE.equals(m.getAttribute(ID_LINKCHECK_MARKER))){
				m.delete();
			}
		}
	}


}
