/*
 * $Id: CheckResoutMonitor.java,v 1.1 2004/01/17 16:49:33 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.linkcheck.core;

import java.util.ArrayList;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;

import com.narucy.webpub.debug.WebpubDebugPlugin;

/**
 * 
 */
class CheckResoutMonitor {

	IFile checkFile = null;
	ArrayList
		finishedFiles = new ArrayList(),
		errorLines = new ArrayList();

	public CheckResoutMonitor(IStreamsProxy proxy) {
		proxy.getOutputStreamMonitor().addListener(new IStreamListener() {
			public void streamAppended(String text, IStreamMonitor streamMonitor) {
				try {
					visitLine(text);
				} catch (CoreException e) {
					WebpubDebugPlugin.handleException(e);
				}
			}
		});
		
		proxy.getErrorStreamMonitor().addListener(new IStreamListener() {
			public void streamAppended(String text, IStreamMonitor streamMonitor) {
				errorLines.add(text);
			}
		});
	}
	
	void visitLine(String text) throws CoreException{
		if(checkFile != null && text.charAt(0) == '\t'){
			String[] lines = text.split("\n");
			for (int i = 0; i < lines.length; i++) {
				String[] entries = lines[i].split(",");
				if(entries.length == 3){
					IMarker marker = createMarker(checkFile);
					marker.setAttribute(LinkCheckConstants.ATTR_INVALID_URL, entries[0]);
					marker.setAttribute(IMarker.LINE_NUMBER, Integer.parseInt(entries[1]));
					marker.setAttribute(IMarker.MESSAGE, entries[2].trim());
				}
			}
		}else{
			Path fileLocation = new Path(text.trim());
			IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(fileLocation);
			if(file != null){
				if(checkFile != null){
					finishedFiles.add(checkFile);
				}
				checkFile = file;
			}
		}
	}
	
	public IFile getCurrentCheckFile(){
		return checkFile;
	}
	
	public String[] getErrorStreamLines(){
		return (String[]) errorLines.toArray(new String[errorLines.size()]);
	}
	
	public int getFinishedFileCount(){
		return finishedFiles.size();
	}
	
	static IMarker createMarker(IResource f) throws CoreException {
		IMarker m = f.createMarker(IMarker.PROBLEM);
		m.setAttribute(LinkCheckConstants.ID_LINKCHECK_MARKER, true);
		return m;
	}
	
	void p(Object o) {
		System.out.println(getClass() + ":" + o);
	}

	
}
