/*
 * $Id: WebpubDebugPlugin.java,v 1.2 2004/01/17 11:50:30 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.debug;

import java.net.URL;

import org.eclipse.core.runtime.*;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * 
 */
public class WebpubDebugPlugin extends Plugin {

	final public static String
		ID_PLUGIN = "com.narucy.webpub.linkchecker";

	static WebpubDebugPlugin instance;

	public WebpubDebugPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		instance = this;
	}
	
	public static WebpubDebugPlugin getDefault(){
		return instance;
	}
	
	public static ImageDescriptor getImageDescriptor(String path){
		URL url = WebpubDebugPlugin.getDefault().find(new Path("icons/full/" + path));
		return ImageDescriptor.createFromURL(url);
	}

	public static void handleException(Exception e) {
		e.printStackTrace();
		instance.getLog().log(new Status(IStatus.ERROR, ID_PLUGIN, IStatus.OK, e.getMessage(), e));
	}		

}
