/*
 * $Id: TocStore.java,v 1.1 2004/01/17 15:51:52 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.toc;

import java.io.*;

import javax.xml.parsers.*;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.*;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.narucy.webpub.core.*;

/**
 * 
 */
final public class TocStore {

	private TocStore(){
	}

	static DocumentBuilder docBuilder;
	static {
		try {
			docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		} catch (ParserConfigurationException e) {
			throw new RuntimeException(e);
		} catch (FactoryConfigurationError e) {
			throw new RuntimeException(e);
		}
	}

	public static void storeToc(Toc toc, IFile file) throws CoreException {
		WebProject wp = (WebProject)file.getProject().getNature(WebProject.ID_NATURE);
		String charset = wp.getString(WebProject.KEY_HT_CHARSET);
		
		try {
			storeToc( toc, new FileOutputStream(file.getLocation().toFile()), charset);
		} catch (IOException e) {
			throw new CoreException(new Status(
				IStatus.ERROR,
				WebpubPlugin.ID_PLUGIN,
				IStatus.OK,
				e.getLocalizedMessage(),
				e));
		}
	}
	
	public static void storeToc(Toc toc, OutputStream out, String charset) throws IOException{
		
		OutputStreamWriter writer = null;
		try{
			writer = new OutputStreamWriter(out, charset);
			writer.write(expandElement(toc));
		}finally{
			if(writer != null){
				writer.flush();
				writer.close();
			}
		}
	}
	
	public static String expandElement(Toc toc){
		Document doc = createDocModel(toc);
		return createElementWriter().expandTag(doc.getDocumentElement());
	}

	static ElementWriter createElementWriter(){
		ElementWriter writer = new ElementWriter();
		writer.setExpandOption("toc", ElementWriter.BEGIN_CHANGELINE | ElementWriter.END_CHANGELINE);
		writer.setExpandOption("topic", ElementWriter.BEGIN_CHANGELINE | ElementWriter.END_CHANGELINE);
		return writer;
	}
	
	static Document createDocModel(Toc toc){
		Document doc = docBuilder.newDocument();
		Element elem = doc.createElement("toc");
		doc.appendChild(elem);
		elem.setAttribute(Topic.LABEL, toc.getLabel());
		Topic[] topics = toc.getSubtopics();
		createTopicsDocModel(topics, doc, elem);
		
		return doc;
	}
	
	static void createTopicsDocModel(Topic[] topics, Document doc, Element elem){
		for(int i=0; i<topics.length; i++) {
			Topic t = topics[i];
			createTocDocModel(t, doc, elem);
		}
	}

	static void createTocDocModel(Topic topic, Document doc, Element parent){
		Element elem = doc.createElement("topic");
		parent.appendChild(elem);
		elem.setAttribute(Topic.LABEL, topic.getLabel());
		elem.setAttribute(Topic.HREF, topic.getHref());
		createTopicsDocModel(topic.getSubtopics(), doc, elem);
	}

}
