/*
 * $Id: TocAdapterFactory.java,v 1.1 2004/01/17 15:51:52 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.toc;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.core.publish.SourceFileSeeker;

/**
 * 
 */
public class TocAdapterFactory implements IAdapterFactory {

	public Object getAdapter(Object adaptableObject, Class adapterType) {
		Topic topic = (Topic)adaptableObject;
		if(IResource.class.equals(adapterType) || IFile.class.equals(adapterType)){
			return topic instanceof Toc ?
				((Toc)topic).getTocFile() :
				findPublishFromAsTopic(topic);
		}
		return null;
	}

	public Class[] getAdapterList() {
		return new Class[]{
			IFile.class,
			IResource.class,
		};
	}

	IFile findPublishFromAsTopic(Topic topic){
		if(topic == null || topic.getHref() == null || topic.getHref().length() == 0){
			return null;
		}
		
		IFile tocFile = topic.getToc().getTocFile();
		if(tocFile != null){
			try {
				WebProject wp = (WebProject)tocFile.getProject().getNature(WebProject.ID_NATURE);
				if(wp != null){
					IFile publishedFile = wp.getFolder(WebProject.KEY_PUBLISH_FOLDER).getFile(new Path(topic.getHref()));
					return new SourceFileSeeker(publishedFile).getPublishFrom();
				}
			} catch (CoreException e) {
				WebpubPlugin.handleException(e);
			}
		}
		
		return null;
	}
	

}
