/*
 * $Id: FileTocAdapterFactory.java,v 1.1 2004/01/17 15:51:51 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.toc;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.WebpubPlugin;

/**
 * 
 */
public class FileTocAdapterFactory implements IAdapterFactory {

	public Object getAdapter(Object adaptableObject, Class adapterType) {
		IFile file = (IFile)adaptableObject;
		try {
			if(Topic.class.equals(adapterType) || Toc.class.equals(adapterType)){
				return getTopic(file);
			}
		} catch (CoreException e) {
			WebpubPlugin.handleException(e);
		}
		return null;
	}

	public Class[] getAdapterList() {
		return new Class[]{
			Topic.class,
			Toc.class,
		};
	}

	Topic getTopic(IFile file) throws CoreException {
		WebProject wp = (WebProject)file.getProject().getNature(WebProject.ID_NATURE);
		if(wp != null){
			IFile[] tocFiles = wp.getTocFiles();
			for (int i = 0; i < tocFiles.length; i++) {
				Toc toc = wp.getToc(tocFiles[i]);
				if(toc != null){
					Topic[] topics = toc.getAllTopics();
					for (int j = 0; j < topics.length; j++) {
						Topic t = (Topic)topics[j];
						if (file.equals((IFile)t.getAdapter(IFile.class))){
							return t;
						}
					}
				}
			}
		}
		return null;
	}

}
