/*
 * $Id: TemplateSynchronizeBuilder.java,v 1.1 2004/01/17 15:51:53 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.template;

import java.util.ArrayList;
import java.util.Map;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.WebpubPlugin;

/**
 * TemplateSynchronizeBuilder.
 */
public class TemplateSynchronizeBuilder extends IncrementalProjectBuilder {

	final public static String
		ID_BUILDER = WebpubPlugin.ID_PLUGIN + ".templateSynchronizeBuilder";
	
	protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
		monitor.beginTask("Begin Template", 3);
		
		try {
			TemplateManager tmplManager = TemplateManager.getManagerInstance( getProject() );
			IResourceDelta delta = getDelta( getProject() );
			if(delta == null){ return null; }
			
			final ArrayList
				added = new ArrayList(),
				removed = new ArrayList();
			
			delta.accept( new IResourceDeltaVisitor() {
				public boolean visit(IResourceDelta d) throws CoreException {
					IResource res = d.getResource();
					if( TemplateManager.isTemplateFile(res) ){
						int kind = d.getKind();
						if(kind == IResourceDelta.REMOVED){
							removed.add(res);
						}else if(kind == IResourceDelta.ADDED || kind == IResourceDelta.CHANGED){
							added.add(res);
						}
					}
					return true;
				}
			});
			monitor.worked(1);
			
			tmplManager.syncronizeTemplate(
				(IFile[])added.toArray(new IFile[added.size()]),
				(IFile[])removed.toArray(new IFile[removed.size()]),
				new SubProgressMonitor(monitor, 1));
			
			return null;
		}
		finally{
			monitor.done();
		}
	}

}
