/*
 * $Id: TemplateParseException.java,v 1.1 2004/01/17 15:51:53 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.template;

import org.eclipse.core.runtime.IPath;

/**
 * 
 */
public class TemplateParseException extends Exception {

	String line;
	int lineNum;
	IPath errorFilePath = null;
	
	public TemplateParseException(String line, int lineNum){
		super("Invalid template: Line Number: " + lineNum);
		this.line = line;
		this.lineNum = lineNum;
	}

	public String getLineText() {
		return line;
	}

	public int getLineNum() {
		return lineNum;
	}
	public IPath getErrorFilePath() {
		return errorFilePath;
	}

	public void setErrorFilePath(IPath path) {
		errorFilePath = path;
	}

	public String getMessage() {
		String extMsg = (errorFilePath != null) ?
			"[errorFilePath=" + errorFilePath.toString() + "]" : "";
		
		return super.getMessage() + extMsg;
	}

}
