/*
 * $Id: Template.java,v 1.1 2004/01/17 15:51:52 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.template;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * 
 */
public class Template implements Cloneable {
	
	/**
	 * NAME_CONTENTS represents inner contents of the template.
	 * in this value line range, page in peculiar.
	 */
	final public static String
		NAME_CONTENTS = "CONTENTS";

	String name;
	ArrayList lines = new ArrayList();
	HashMap properties = new HashMap();
	
	public Template(String name){
		this.name = name;
	}
	
	public void setProperty(Object key, Object value){
		properties.put(key, value);
	}
	
	public Object getProperty(Object key){
		return properties.get(key);
	}
	
	public Object[] getPropertyKeys(){
		return properties.keySet().toArray();
	}

	public Template[] getChildrenTemplates(){
		return getChildrenTemplates(null);
	}

	public Template[] getChildrenTemplates(String name){
		ArrayList tmpls = new ArrayList();
		Object[] ls = lines.toArray();
		for (int i = 0; i < ls.length; i++) {
			Object obj = ls[i];
			if( obj instanceof Template && ( name == null || ((Template)obj).getName().equals(name)) ){
				tmpls.add(obj);
			}
		}
		return (Template[])tmpls.toArray(new Template[0]);
	}
	
	public void addTemplate(Template template){
		lines.add(template);
	}
	
	public void addLine(String line){
		lines.add(line);
	}
	
	public String[] getTemplateNames(){
		ArrayList list = new ArrayList();
		Template[] tmpls = getAllTemplates();
		for (int i = 0; i < tmpls.length; i++) {
			String n = tmpls[i].getName();
			if( !list.contains(n) ){
				list.add(n);
			}
		}
		return (String[])list.toArray(new String[list.size()]);
	}

	public String getJoinedLines(){
		String[] lines = getLines();
		StringBuffer buffer = new StringBuffer();
		for (int i = 0; i < lines.length; i++) {
			buffer.append( lines[i] );
			buffer.append('\n');
		}
		return buffer.toString();
	}
	
	public String[] getLines(){
		ArrayList lines = new ArrayList();
		createLines(lines);
		return (String[])lines.toArray(new String[lines.size()]);
	}
	
	void createLines(ArrayList list){
		Object[] ls = lines.toArray();
		for (int i=0; i<ls.length; i++) {
			Object l = ls[i];
			if(l instanceof String){
				list.add( l );
			}
			else if(l instanceof Template){
				Template t = (Template)l;
				t.createLines(list);
			}
		}
	}

	public String getName() {
		return name;
	}

	public Template[] getAllTemplates(){
		return getAllTemplates(null);
	}
	
	public Template[] getAllTemplates(String name){
		ArrayList list = new ArrayList();
		
		Template[] tmpls = getChildrenTemplates();
		for (int i = 0; i < tmpls.length; i++) {
			findTmpls(tmpls[i], list, name);
		}
		
		return (Template[])list.toArray(new Template[list.size()]);
	}

	static void findTmpls( Template template, ArrayList list, String name){
		if( name == null || template.getName().equals(name)){
			list.add(template);
		}
		Template[] tmpls = template.getChildrenTemplates();
		for (int i = 0; i < tmpls.length; i++) {
			findTmpls(tmpls[i], list, name);
		}
	}

	public Template[] getInvalidTemplates(){
		ArrayList list = new ArrayList();
		Template[] tmpls = getAllTemplates();
		for (int i = 0; i < tmpls.length; i++) {
			Template t1 = (Template)tmpls[i];
			for (int j = i+1; j < tmpls.length; j++) {
				Template t2 = (Template)tmpls[j];
				if( !list.contains(t2) && t1.getName().equals(t2.getName()) && !t1.equals(t2) ){
					list.add(t2);
				}
			}
		}
		return (Template[])list.toArray(new Template[list.size()]);
	}

	boolean hasTemplate(String n){
		String[] names = getTemplateNames();
		for (int i = 0; i < names.length; i++) {
			if( names[i].equals(n) ){
				return true;
			}
		}
		return false;
	}
	
	public void modifyTmpl(Template newTmpl) throws TemplateParseException {
		String newTmplName = newTmpl.getName();
		if( newTmplName.equals(Template.NAME_CONTENTS) ){
			throw new IllegalArgumentException("Invalid template type:" + Template.NAME_CONTENTS);
		}

		Template[] childs = newTmpl.getChildrenTemplates();
		for (int i = 0; i < childs.length; i++) {
			Template t = childs[i];
			if( !t.getName().equals(Template.NAME_CONTENTS) ){
				modifyTmpl(t);
			}
		}

		// do modify
		HashMap replaceTargetFlags = new HashMap();
		
		Template[] origTmpls = getChildrenTemplates();
		for (int i = 0; i < origTmpls.length; i++) {
			replaceTargetFlags.clear();
			Template origTmpl = origTmpls[i];
			
			String origTmplName = origTmpl.getName();
			if( origTmplName.equals(Template.NAME_CONTENTS) ){
				continue;
			}
			origTmpl.modifyTmpl(newTmpl);
			
			if( !origTmplName.equals(newTmplName) ){
				continue;
			}
			
			Template editTemplate = new Template(newTmplName);
			Object[] lineObjs = newTmpl.lines.toArray();
			for (int j = 0; j < lineObjs.length; j++) {
				Object o = lineObjs[j];
				if( o instanceof String){
					editTemplate.addLine( (String)o);
				}
				else if (o instanceof Template) {
					Template childTmpl = (Template)o;
					String childTmplName = childTmpl.getName();
					
					int index = replaceTargetFlags.containsKey(childTmplName) ?
						((Integer)replaceTargetFlags.get(childTmplName)).intValue() + 1 : 0;
					replaceTargetFlags.put(childTmplName, new Integer(index));
					
					Template[] ts = origTmpl.getChildrenTemplates(childTmplName);
					if(ts != null && ts.length > index){
						editTemplate.addTemplate( ts[index] );
					} else {
						Template t = new Template(childTmplName);
						t.addLine("<!-- $begin:" + childTmplName + "$ -->\n");
						t.addLine("<!-- $end:" + childTmplName + "$ -->\n");
						editTemplate.addTemplate( t );
					}
				}
			}
			
			int index = lines.indexOf(origTmpl);
			lines.remove(index);
			lines.add(index, editTemplate);
		}
	}

	public boolean equals(Object obj) {
		if(obj == this){
			return true;
		}
		if(obj == null || !(obj instanceof Template)){
			return false;
		}
		
		Template other = (Template)obj;
		if( !name.equals(other.getName()) ){
			return false;
		}
		
		// if template name is CONTENTS do not compare contents.
		if( name.equals(NAME_CONTENTS) ){
			return true;
		}
		
		Object[] ls = lines.toArray();
		Object[] otherLs = other.lines.toArray();
		if(ls.length != otherLs.length){
			return false;
		}
		for (int i = 0; i < ls.length; i++) {
			if( !ls[i].equals(otherLs[i]) ){
				return false;
			}
		}
		return true;
	}
	
	/**
	 * This clone method is to return deep copy instance.
	 */	
	public Object clone(){
		Template tmpl = new Template(name);
		Object[] ls = lines.toArray();
		for (int i = 0; i < ls.length; i++) {
			Object o = ls[i];
			if(o instanceof String){
				tmpl.lines.add(o);
			} else if (o instanceof Template){
				tmpl.lines.add( ((Template)o).clone() );
			}
		}
		tmpl.properties = (HashMap)this.properties.clone();
		return tmpl;
	}
	
	void p(Object o) {
		System.out.println(getClass() + ":" + o);
	}

}
