/*
 * $Id: PublisherRegistory.java,v 1.1 2004/01/17 15:51:55 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.*;

/**
 * <p>
 * PublisherRegistory provides manage publisher plug-in.
 * This instance keeps publisher datas.
 */
public class PublisherRegistory {

	static PublisherRegistory instance = null;

	public static PublisherRegistory getInstance(){
		if( instance == null){
			instance = new PublisherRegistory();
		}
		return instance;
	}

	Map publishOrders = initPublisherExtensions();

	private PublisherRegistory() {
	}
		
	/**
	 * Create publish orders that Map instance each keys are
	 * publish-by-key names values are String array that index 0 is
	 * publish script full path, index 1 is class name.
	 */
	Map initPublisherExtensions(){
		Map orders = new HashMap();
		
		// Load publish extension points.
		IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint("com.narucy.webpub.core.publishers");
		IExtension[] exts = extPoint.getExtensions();
		for (int i = 0; i < exts.length; i++) {
			IExtension ext = exts[i];
			IConfigurationElement[] elems = ext.getConfigurationElements();
			for (int j = 0; j < elems.length; j++) {
				IConfigurationElement elem = elems[j];
				if( elem.getName().equals("publisher") ){
					String id = elem.getAttribute("id");
					Path scriptFilePath = new Path(elem.getAttribute("script"));
					URL url = ext.getDeclaringPluginDescriptor().find( scriptFilePath );
					if(url == null){
						throw new RuntimeException("Invalid publisher extension entry: " + id  + " (" + scriptFilePath + " is not found)");
					}
					String scriptFullPath = url.getFile();
					String klass = elem.getAttribute("class");
					String description = elem.getAttribute("description");
					
					orders.put(id, new String[]{ scriptFullPath, klass, description} );
				}
			}
		}
		
		return orders;
	}

	/**
	 * Returns publish key names.
	 */
	public String[] getPublishByKeys(){
		return (String[])publishOrders.keySet().toArray(new String[publishOrders.size()]);
	}
	
	/**
	 * Returns publisher script file location (full path for local)
	 * for specify publish key name.
	 */
	public String getPublishScriptFileLocation(String by){
		Object publisher = publishOrders.get(by);
		return (publisher != null) ? ((String[])publisher)[0] : null;
	}
	
	/**
	 * Returns publisher class name for specify publish key name.
	 */
	public String getPublishClassName(String by){
		Object publisher = publishOrders.get(by);
		return (publisher != null) ? ((String[])publisher)[1] : null;
	}
	
	/**
	 * Returns publisher description. if not specify description.
	 * return null.
	 */
	public  String getPublishDescription(String by){
		Object publisher = publishOrders.get(by);
		return (publisher != null) ? ((String[])publisher)[2] : null;
	}
	

}
