/*
 * $Id: PublishPropertyStore.java,v 1.1 2004/01/17 15:51:55 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.io.*;

import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.*;

import com.narucy.webpub.core.WebpubPlugin;

/**
 * 
 */
public class PublishPropertyStore {

	public PublishPropertyStore() {
		super();
	}
	
	public void store(File file, Document doc){
		FileOutputStream out = null;
		try {
			XmlDocument xmlDoc =
				(doc instanceof XmlDocument) ?
					(XmlDocument)doc : cloneDocument(doc);
			
			out = new FileOutputStream(file);
			xmlDoc.write(out);
		} catch (FileNotFoundException e) {
			WebpubPlugin.handleException(e);
		} catch (IOException e) {
			WebpubPlugin.handleException(e);
		}finally{
			if( out != null) {
				try {
					out.close();
				} catch (IOException e1) {
					WebpubPlugin.handleException(e1);
				}
			}
		}
	}

	static XmlDocument cloneDocument(Document doc){
		XmlDocument newDoc = new XmlDocument();
		Element newRootElem = newDoc.createElement("publishers");
		newDoc.appendChild(newRootElem);
		NodeList nodeList = doc.getDocumentElement().getElementsByTagName("mapping");
		for(int i=0; i<nodeList.getLength(); i++){
			Element mappingElem = (Element)nodeList.item(i);
			Element publishElem = (Element)mappingElem.getElementsByTagName("publish").item(0);
					
			// create new node
			Element newMappingElem = newDoc.createElement("mapping");
			newRootElem.appendChild(newMappingElem);
			
			Element newPublishElem = newDoc.createElement("publish");
			newMappingElem.appendChild(newPublishElem);
			
			newMappingElem.setAttribute("pattern", mappingElem.getAttribute("pattern") );
			NamedNodeMap map = publishElem.getAttributes();
			for(int j=0; j<map.getLength(); j++){
				Node n = map.item(j);
				newPublishElem.setAttribute(n.getNodeName(), n.getNodeValue());
			}
		}
		return newDoc;
	}


}

