/*
 * $Id: IllegalConfigurationException.java,v 1.1 2004/01/17 15:51:55 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import org.eclipse.core.resources.IFile;

/**
 * 
 */
public class IllegalConfigurationException extends Exception {

	final public static int
		UNKNOWN_LINE_NUMBER = -1;

	IFile illegalFile;
	int line;

	public IllegalConfigurationException(Throwable e){
		super(e);
	}
	
	public IllegalConfigurationException(String msg){
		this( msg, null);
	}

	public IllegalConfigurationException(String msg, IFile file){
		this(msg, file, UNKNOWN_LINE_NUMBER);
	}

	public IllegalConfigurationException(String msg, IFile file, int line){
		super(msg);
		this.illegalFile = file;
		this.line = line;
	}

	public IFile getIllegalFile() {
		return illegalFile;
	}

	public int getLine() {
		return line;
	}

}
