/*
 * $Id: BuildResultReader.java,v 1.1 2004/01/17 15:51:55 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

import com.narucy.webpub.core.TextReader;

class BuildResultReader extends Thread {

	final static
		String COMPLETE_CODE = "!!complete!!",
		BEGIN_ERROR_CODE = "!!begin-error!!",
		END_ERROR_CODE = "!!end-error!!";

	boolean done = false;

	ArrayList
		completes = new ArrayList(),
		unknownLines = new ArrayList();

	HashMap errors = new HashMap();
	TextReader reader;

	BuildResultReader(InputStream stream, String charset) throws IOException {
		reader = new TextReader(stream, charset);
	}

	public void run() {
		try {
			String[] errorEntry = null;
			ArrayList errorLines = new ArrayList();
			while (reader.hasNext()) {
				String line = reader.nextLine();
				if (isConsoleCode(line, END_ERROR_CODE)) {
					errors.put(errorEntry, errorLines.toArray(new String[errorLines.size()]));
					errorEntry = null;
					errorLines.clear();
					continue;
				}
				if (errorEntry != null) {
					errorLines.add(line);
					continue;
				}
				if (isConsoleCode(line, BEGIN_ERROR_CODE)) {
					String[] entry = line.substring(BEGIN_ERROR_CODE.length()).split("\\s+");
					if (entry.length == 3) {
						errorEntry = entry;
						continue;
					}
				}
				if (isConsoleCode(line, COMPLETE_CODE)) {
					String[] entry = line.substring(COMPLETE_CODE.length()).split("\\s+");
					if (entry.length == 3) {
						completes.add(entry);
						continue;
					}
				}

				unknownLines.add(line);
			}
		} finally {
			done = true;
		}
	}

	static boolean isConsoleCode(String line, String code) {
		return 
			line.length() != 0 &&
			line.charAt(0) == '!' && line.charAt(1) == '!' && // for performance up
			line.indexOf(code) == 0;
	}

	boolean isDone() {
		return done;
	}

	String[] getUnparsedLines() {
		return (String[]) unknownLines.toArray(new String[unknownLines.size()]);
	}

}