/*
 * $Id: BuildErrorReader.java,v 1.1 2004/01/17 15:51:55 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import com.narucy.webpub.core.TextReader;

/**
 * manage error stream.
 */
class BuildErrorReader extends Thread {

	TextReader reader;
	boolean done = false;
	ArrayList readLog = new ArrayList();

	BuildErrorReader(InputStream stream, String charset) throws IOException {
		this.reader = new TextReader(stream, charset);
	}

	public void run() {
		try {
			while (reader.hasNext()) {
				String line = reader.nextLine();
				if (line.indexOf("warning:") == -1) {
					readLog.add(line);
				}
				System.err.println(line);
			}
		} finally {
			done = true;
		}
	}

	boolean isDone() {
		return done;
	}

	String[] getErrorLog() {
		return (String[]) readLog.toArray(new String[readLog.size()]);
	}

}