/*
 * $Id: PresetManager.java,v 1.1 2004/01/17 15:51:56 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.preset;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.WebpubPlugin;

/**
 * PresetManager provides to load extension point
 * "com.narucy.webpub.core.presets".
 */
public class PresetManager {
	
	final public static String
		ID_PRESETS_EXTENSION = WebpubPlugin.ID_PLUGIN + ".presets";
	
	static PresetManager instance = new PresetManager();

	public static PresetManager getInstance(){
		return instance;
	}

	ArrayList presets = null;

	public PresetManager(){
	}

	public Preset[] getPrests() {
		if(presets == null){
			init();
		}
		return (Preset[])presets.toArray(new Preset[presets.size()]);
	}

	void init() {
		presets = new ArrayList();
		
		// gets extensions
		IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint(ID_PRESETS_EXTENSION);
		IExtension[] extensions = extensionPoint.getExtensions();
		
		// search extensions.
		for (int i = 0; i < extensions.length; i++) {
			IExtension ext = extensions[i];
			// create presets model.
			IConfigurationElement[] elems = ext.getConfigurationElements();
			for (int j = 0; j < elems.length; j++) {
				IConfigurationElement elem = elems[j];
				if( elem.getName().equals("preset") ){
					try{
						presets.add( createPreset(elem));
					}
					catch(MalformedURLException e){
						WebpubPlugin.handleException(e);
					}
				}
			}
		}
	}
	
	/*
	 *     <preset
	 *          name="Company"
	 *          toc="presets/company/toc.xml">
	 *          htSources="presets/company/ht_sources/"
	 *          scripts="presets/company/scripts/"
	 *        <template
	 *              path="presets/company/ht_sources/base.html" default="true">
	 *        </template>
	 *     </preset>
	 */

	/**
	 * Creates Preset instance as specify IConfigurationElement.
	 */	
	static Preset createPreset(IConfigurationElement elem) throws MalformedURLException {
		IPluginDescriptor descriptor = elem.getDeclaringExtension().getDeclaringPluginDescriptor();
		URL baseDirectory = descriptor.find( new Path("/") );
		
		// get name
		String name = elem.getAttribute("name");
		if( name == null){
			throw new IllegalArgumentException("Attribute is not setted: name");
		}
		
		String tocFileName = elem.getAttribute("toc");
		if( tocFileName == null ){
			throw new IllegalArgumentException("Attribute is not setted: toc");
		}
		
		ArrayList htSelections = new ArrayList();
		String defaultSelection = null;
		
		IConfigurationElement[] elements = elem.getChildren();
		for (int i=0; i<elements.length; i++) {
			IConfigurationElement element = elements[i];
			String elemName = element.getName();
			
			// choose ht selections
			if(elemName.equals("htSelections")){
				// template location.
				IConfigurationElement[] htElems = element.getChildren();
				for (int j = 0; j < htElems.length; j++) {
					IConfigurationElement e = htElems[j];
					if (e.getName().equals("htItem") ){
						String path = e.getAttribute("path");
						if(path == null){
							throw new IllegalArgumentException("htItem element need to path attribute");
						}
						htSelections.add(path);
						String defaultItem = e.getAttribute("default");
						if( defaultItem != null && Boolean.valueOf(defaultItem).booleanValue() ){
							defaultSelection = path;
						}
					}
				}
			}
		}
		
		String initialHtsDirectory = elem.getAttribute("initialHts");
		String initialResourcesDirectory = elem.getAttribute("initialResources");
		String initialScriptsDirectory = elem.getAttribute("initialScripts");

		return new Preset(
			name,
			baseDirectory,
			tocFileName,
			(String[])htSelections.toArray(new String[htSelections.size()]),
			defaultSelection,
			initialHtsDirectory,
			initialResourcesDirectory,
			initialScriptsDirectory);
	}


}
