/*
 * $Id: Preset.java,v 1.1 2004/01/17 15:51:56 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.preset;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.core.runtime.CoreException;
import org.xml.sax.SAXException;

import com.narucy.webpub.core.toc.Toc;
import com.narucy.webpub.core.toc.TocFactory;


/**
 * <p>
 * Preset provides project creation wizard.
 * 
 * <dl>
 * <dt>initialHtsDirectory</dt>
 * <dd>
 * copying HTML source folder as specify directory contain URL.
 * (This folder name need to first dot.
 * </dd>
 * <dt>scriptsDirectory
 * <dd>
 * copying script folder as specify directory contain URL.
 * (This folder name need to first dot.
 * </dd>
 * 
 */
public class Preset {

	String name;
	URL[] htSelectionURLs;

	URL
		baseDirectory,
		tocURL,
		defaultSelectionURL,
		initialResourcesDirectory,
		initialHtsDirectory,
		scriptsDirectory;

	public Preset(
			String name,
			URL baseDirectory,
			String tocPath,
			String[] htSelectionPaths,
			String defaultSelectionPath,
			String htDirectoryPath,
			String initialResourceDirectoryPath,
			String scriptsDirectoryPath) throws MalformedURLException {
		
		this.name = name;
		this.baseDirectory = baseDirectory;
		
		tocURL = new URL(baseDirectory, tocPath);
		
		htSelectionURLs = new URL[htSelectionPaths.length];
		for (int i = 0; i < htSelectionPaths.length; i++) {
			String path = htSelectionPaths[i];
			URL f = new URL(baseDirectory, path);
			htSelectionURLs[i] = f;
			if( path.equals( defaultSelectionPath) ){
				defaultSelectionURL = f;
			}
		}
		
		if( htDirectoryPath != null){
			initialHtsDirectory = new URL( baseDirectory, htDirectoryPath);
		}
		if( initialResourceDirectoryPath != null){
			initialResourcesDirectory = new URL(baseDirectory, initialResourceDirectoryPath);
		}
		if( scriptsDirectoryPath != null){
			scriptsDirectory = new URL( baseDirectory, scriptsDirectoryPath);
		}
	}

	public Toc createToc() throws SAXException, CoreException, IOException {
		return TocFactory.createToc(tocURL.openStream());
	}
	
	public URL[] getHtSelectionURLs() throws IOException, CoreException {
		return (URL[])htSelectionURLs.clone();
	}

	public URL getDefaultSelectionURL() {
		return defaultSelectionURL;
	}

	public String getName() {
		return name;
	}

	public URL getInitialHtsDirectory() {
		return initialHtsDirectory;
	}

	public URL getScriptsDirectory() {
		return scriptsDirectory;
	}

	public URL getInitialResourcesDirectory() {
		return initialResourcesDirectory;
	}

	public URL getBaseDirectory() {
		return baseDirectory;
	}

}
