/*
 * $Id: WebProjectConfigurationLoader052.java,v 1.1 2004/01/17 15:51:54 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core;

import java.io.IOException;

import javax.xml.parsers.*;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.*;
import org.xml.sax.SAXException;

/**
 * Web Project configuration loader for old version (0.5.2 compatibility).
 */
class WebProjectConfigurationLoader052 {

	static DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();

	public static boolean reloadDescription(WebProject wp){
		try{
			IProject proj = wp.getProject();
			IFile descriptionFile = proj.getFile(WebProject.DESCRIPTION_FILENAME);
			if( !descriptionFile.exists() ){
				return false;
			}
			DocumentBuilder builder = builderFactory.newDocumentBuilder();
			Document doc = builder.parse(descriptionFile.getContents());
			
			Element element = doc.getDocumentElement();
			wp.setValue(WebProject.KEY_HTSOURCES_FOLDER, choosePathAsElements(element, "htSourcesFolder") );
			wp.setValue(WebProject.KEY_SCRIPTS_FOLDER, choosePathAsElements(element, "scriptsFolder") );
			wp.setValue(WebProject.KEY_PUBLISH_FOLDER, choosePathAsElements(element, "publishFolder") );
			return true;
		}
		catch(ParserConfigurationException e){
			WebpubPlugin.handleException(e);
		} catch(IOException e){
			WebpubPlugin.handleException(e);
		} catch(SAXException e){
			WebpubPlugin.handleException(e);
		} catch (CoreException e) {
			WebpubPlugin.handleException(e);
		}
		return false;
	}
	
	static String choosePathAsElements(Element element, String name) throws CoreException {
		Node node = element.getElementsByTagName(name).item(0);
		if( node != null && node instanceof Element){
			return ((Element)node).getAttribute("path");
		}
		return null;
	}

}
