/*
 * $Id: WebProjectAdapterFactory.java,v 1.1 2004/01/17 15:51:53 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;

import com.narucy.webpub.core.template.TemplateManager;

/**
 * WebProjectAdapterFactory roles easy to access relational instances.
 */
public class WebProjectAdapterFactory implements IAdapterFactory {

	public Object getAdapter(Object obj, Class adapterType) {
		try{
			IProject proj = (IProject)obj;
			if( WebProject.class.equals(adapterType) ){
				return ((IProject)obj).getNature(WebProject.ID_NATURE);
			}
			else if ( TemplateManager.class.equals(adapterType) ){
				return TemplateManager.getManagerInstance(proj);
			}
		}
		catch(CoreException e){
			WebpubPlugin.handleException(e);
		}
		return null;
	}

	public Class[] getAdapterList() {
		return new Class[]{
			WebProject.class,
			TemplateManager.class,
		};
	}


}
