/*
 * $Id: TextReader.java,v 1.1 2004/01/17 15:51:53 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core;

import java.io.*;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * Utility for text reader.
 */
public class TextReader implements Iterator {
	
	InputStreamReader in;
	
	BufferedReader reader = null;
	String nextLine = null;
	
	public TextReader(URL url) throws IOException {
		this(url, null);
	}

	public TextReader(URL url, String charSet) throws IOException {
		this(url.openStream(), charSet);
	}
	
	public TextReader(InputStream stream) {
		this(stream, null);
	}

	public TextReader(InputStream stream, String charset) {
		try{
			in = charset != null ?
				new InputStreamReader(stream, charset) :
				new InputStreamReader(stream);
		}catch(IOException e){
			handleException(e);
		}
	}
	
	public synchronized void close() {
		try {
			if(reader != null){
				reader.close();
			}
		} catch (IOException e) {
			handleException(e);
		}
	}
	
	public boolean hasNext(){
		if( reader == null){
			init();
		}
		return ( nextLine != null);
	}
	
	public Object next() {
		return nextLine();
	}

	void init(){
		reader = new BufferedReader(in);
		try {
			nextLine = reader.readLine();
		} catch (IOException e) {
			handleException(e);
		}
	}

	public String nextLine() {
		if(reader == null){
			init();
		}
		try{
			String current = nextLine;
			nextLine = reader.readLine();
			if( nextLine == null){
				close();
			}
			return current;
		}catch(IOException e){
			return handleException(e);
		}
	}

	public String[] toLines() {
		ArrayList list = new ArrayList();
		while(hasNext()){
			list.add( nextLine());
		}
		return (String[])list.toArray(new String[list.size()]);
	}

	public String joinedLines() {
		StringBuffer buff = new StringBuffer();
		String[] lines = toLines();
		for (int i = 0; i < lines.length; i++) {
			buff.append( lines[i] );
			buff.append('\n');
		}
		return buff.toString();
	}

	public void remove() {
	}

	protected String handleException(IOException e){
		e.printStackTrace();
		throw new RuntimeException(e);
	}

}