/*
 * $Id: RubyStacktrace.java,v 1.1 2004/01/17 15:51:53 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 
 */
public class RubyStacktrace extends Throwable {

	public static class TraceItem {
		
		final public String script, occasionIn;
		final public int lineNumber;
		
		public TraceItem(String script, int lineNumber, String occasionIn){
			this.script = script;
			this.lineNumber = lineNumber;
			this.occasionIn = occasionIn;
		}
		
		protected Object clone(){
			return new TraceItem(script, lineNumber, occasionIn);
		}
	}

	static Pattern
		firstLinePattern = Pattern.compile("^([^\t].+\\.rb):(\\d+):(.+)$"),
		traceLinePattern = Pattern.compile("^\tfrom (.+\\.rb):(\\d+)(?:|:(.+))$");

	public static RubyStacktrace[] createFromLines(String[] lines){
		ArrayList traces = new ArrayList();
		
		RubyStacktrace trace = null;
		for (int i = 0; i < lines.length; i++) {
			String line = lines[i];
			Matcher beginTraceMatch = firstLinePattern.matcher(line);
			if( beginTraceMatch.matches() ){
				if(trace != null){
					traces.add(trace);
				}
				trace = new RubyStacktrace(
					beginTraceMatch.group(1),
					Integer.parseInt(beginTraceMatch.group(2)),
					beginTraceMatch.group(3));
			}
			if(trace != null){
				Matcher traceMatch = traceLinePattern.matcher(line);
				if(traceMatch.matches()){
					trace.addItem(
						traceMatch.group(1),
						Integer.parseInt( traceMatch.group(2) ),
						traceMatch.group(3));
				}
			}
		}
		if( trace != null){
			traces.add(trace);
		}
		
		return (RubyStacktrace[])traces.toArray(new RubyStacktrace[traces.size()]);
	}
	
	ArrayList items = new ArrayList();

	final public String script, message;
	final public int lineNumber;

	public RubyStacktrace(String script, int lineNumber, String message){
		super(script + ":" + lineNumber + ":" + message);
		this.script = script;
		this.lineNumber = lineNumber;
		this.message = message;
	}

	public void addItem(String script, int lineNumber, String occasionIn){
		addItem( new TraceItem(script, lineNumber, occasionIn) );
	}

	public void addItem(TraceItem item){
		items.add(item);
	}
	
	public TraceItem[] getTraceItems(){
		return (TraceItem[])items.toArray(new TraceItem[items.size()]);
	}

	public void printStackTrace(PrintWriter s) {
		s.println( getMessage() );
		for(int i=0; i<items.size(); i++){
			TraceItem item = (TraceItem)items.get(i);
			s.print("\tfrom " + item.script + ":" + item.lineNumber);
			if( item.occasionIn != null){
				s.print(":" + item.occasionIn);
			}
			s.println();
		}
	}

	public void printStackTrace(PrintStream s) {
		printStackTrace(new PrintWriter(s));
	}

}
