/*
 * $Id: InterpreterCheckerManager.java,v 1.1 2004/01/17 15:51:54 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core;

import java.io.*;
import java.net.URL;
import java.util.HashMap;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

/**
 * 
 */
public class InterpreterCheckerManager {

	static InterpreterCheckerManager instance = null;
	
	public static InterpreterCheckerManager getInstance() {
		if(instance == null){
			instance = new InterpreterCheckerManager();
		}
		return instance;
	}

	String toolCommandPath;
	HashMap checkerEntries = new HashMap();

	private InterpreterCheckerManager() {
		WebpubPlugin plugin = WebpubPlugin.getDefault();
		toolCommandPath = plugin.find(new Path("scripts/bin/checktool.rb")).getFile();

		String[] entries = {
			"interpreter", "scripts/lib/webpub/interpreter_checker.rb", "WebPub::InterpreterChecker","Web Publisher requires Ruby that is foundation technorogies for document publish version is and need to version 1.8 or higher. http:///www.ruby-lang.org",
			"amrita", "scripts/lib/webpub/amrita_checker.rb", "WebPub::AmritaChecker","Amrita is a a html/xhtml template library for Ruby. http://raa.ruby-lang.org/list.rhtml?name=amrita",
			"rd", "scripts/lib/webpub/rd_checker.rb", "WebPub::RDChecker","RD is document RDtool is RD formater and utilities.. http://raa.ruby-lang.org/list.rhtml?name=rdtool",
		};
		
		for(int i=0; i<entries.length; i+=4){
			URL url = plugin.find(new Path(entries[i+1]));
			String fullPath = url.getFile();
			checkerEntries.put(entries[i], new String[]{fullPath, entries[i+2], entries[i+3]});
		}
	}

	public String[] getGlobalEntryKeys(){
		return (String[])checkerEntries.keySet().toArray(new String[checkerEntries.size()]);
	}

	public InterpreterCheckResult check(String interpreter) throws CoreException {
		return check(interpreter, getGlobalEntryKeys());
	}
	
	public String getDescription(String key){
		if( checkerEntries.containsKey(key) ){
			return ((String[])checkerEntries.get(key))[2];
		}else{
			return null;
		}
	}

	String createArguments(File resultDistFile, String[] keys){
		StringBuffer buff = new StringBuffer(toolCommandPath + ' ');
		
		buff.append( resultDistFile.toString() + ' ');
		
		for (int i = 0; i < keys.length; i++) {
			String k = keys[i];
			if( checkerEntries.containsKey(k) ){
				String[] entry = (String[])checkerEntries.get(k);
				buff.append(k + ' ' + entry[0] + ' ' + entry[1] + ' ');
			}else{
				return null;
			}
		}
		
		return buff.toString();
	}

	public InterpreterCheckResult check(String interpreter, String[] keys) throws CoreException {
		if( !new File(interpreter).exists() ){
			InterpreterCheckResult res = new InterpreterCheckResult();
			res.put("interpreter", "Interpreter not found",  3);
			return res;
		}
		
		File resultDistFile = new File(
			System.getProperty("java.io.tmpdir"),
			String.valueOf(System.currentTimeMillis()) +  "InterpreterEnviornmentChecker.result");
		
		try{
			String args = createArguments(resultDistFile, keys);
			
			Process process = WebpubPlugin.rubyExec(interpreter, args, null);
			readAllStream(process.getErrorStream());
			readAllStream(process.getInputStream());
			
			int code = process.waitFor();
			if( code == 0){
				return createResult(resultDistFile);
			}else{
				throw new IOException("IO error occation in checking ruby interpreter enviornment.");
			}
		} catch(InterruptedException e){
			WebpubPlugin.handleException(e);
		} catch (IOException e) {
			WebpubPlugin.handleException(e);
		}
		return null;
	}
	
	static void readAllStream(final InputStream stream){
		new Thread(){
			public void run(){
				new TextReader(stream).joinedLines();
			}
		}.start();
	}
	
	InterpreterCheckResult createResult(File resultDistFile) throws IOException{
		TextReader reader = new TextReader(new FileInputStream(resultDistFile));
		InterpreterCheckResult result = new InterpreterCheckResult();
		while(reader.hasNext()){
			String[] entries = reader.nextLine().split(",");
			result.put(entries[0], entries[1], Integer.parseInt(entries[2]));
		}
		
		return result;
	}
	
}
