#
# $Id: runner_test.rb,v 1.1 2004/01/10 07:37:28 hn Exp $
# Copyright (c) Narushima Hironori.
#

$: << File.expand_path(File.join(File.dirname(__FILE__), '../'))

require 'test/unit'
require 'linkchecker/runner'
require 'tmpdir'

class LinkChecker::RunnerTest < Test::Unit::TestCase

	def setup
		@tmp_dir = Dir.pwd
		Dir.chdir File.dirname(__FILE__)
	end
	
	def test_run_with_net
		webdir = '../../../test_resources/webcontents_withnet'
		lines = check(webdir)
		
		#puts lines
		# a.html has not error
		assert %r!/a.html\n../!m === lines
		
		#error
		assert %r!^\thttp://webpub.narucy.com/foo,3! === lines
		assert %r!^\tftp://ftp.ring.gr.jp/foo,4! === lines
		assert %r!^\tbx.html,5! === lines
		
		runner = LinkChecker::Runner.new
		runner.check_file_extensions << 'xhtml'
		
		lines = check(webdir, runner)
		assert %r!^../../../test_resources/webcontents_withnet/b.xhtml! === lines

		runner.check_file_extensions.delete('xhtml')
		
		runner.ignore_link_regexp << /narucy\.com/
		lines = check(webdir, runner)
		
		assert !(%r!^\thttp://webpub.narucy.com/foo! === lines)

		runner.checkers.delete('ftp')
		lines = check(webdir, runner)
		assert !(%r!^\tftp://ftp.ring.gr.jp/foo,4! === lines)
	end

	def test_run
		lines = check('../../../test_resources/webcontents')
		
		assert %r!^../../../test_resources/webcontents/a.html$! === lines
		assert %r!^../../../test_resources/webcontents/b.html$! === lines
		assert %r!^../../../test_resources/webcontents/c.html$! === lines
		
		assert %r!^\tax.html,3,file not found:! === lines
		assert %r!^\tbx.html,5,file not found:! === lines
		assert %r!^\tcx.html,8,file not found:! === lines
		assert %r!^\tdx.html,9,file not found:! === lines
		
		assert !(%r!^\tz.html! === lines)
	end
	
	def check(test_webcontents, runner = LinkChecker::Runner.new)
		dist_file = (Dir.tmpdir + '/LinkChecker_RunnerTest.tmp')
		begin
			open(dist_file, 'w') { |fh|
				_stdout = $stdout
				begin
					$stdout = fh
					runner.run test_webcontents
				ensure
					$stdout = _stdout
				end
			}
			IO.read(dist_file)
		ensure
			File.delete(dist_file) if File.exist?(dist_file)
		end
	end
	
	def teardown
		Dir.chdir(@tmp_dir)
	end

end
