#
# $Id: checkers_test.rb,v 1.1 2004/01/10 07:37:28 hn Exp $
# Copyright (c) Narushima Hironori.
#

$: << File.expand_path(File.join(File.dirname(__FILE__), '../'))

require 'linkchecker/checkers'
require 'test/unit'

class LinkChecker::CheckersTest < Test::Unit::TestCase
	
	include LinkChecker

	def test_http_check
		checker = HTTPChecker.new
		assert_equal(
			'getaddrinfo: no address associated with hostname.',
			checker.check(URI.parse('http://foo')) )
		
		assert_nil checker.check(URI.parse('http://webpub.narucy.com'))
	end
	
	def test_ftp_check
		checker = FTPChecker.new
		assert_equal(
			'getaddrinfo: no address associated with hostname.',
			checker.check(URI.parse('ftp://foo')) )
		
		assert_nil checker.check(URI.parse('ftp://ftp.ring.gr.jp/index.html.ja'))
	end

	def test_file_check
		checker = FileChecker.new
		
		assert_equal(
			'file not found: /foo/bar/foofile',
			checker.check(URI.parse('/foo/bar/foofile'), '/x/y/z') )
		
		assert_nil checker.check(URI.parse(__FILE__), '/x/y/z')
	end

end