#
# $Id: webproject_test.rb,v 1.1 2004/01/17 12:02:27 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

project_dir = File.dirname(__FILE__).sub(/(com.narucy.webpub.core).+/, '\1')
Dir.chdir project_dir
$: << project_dir + '/scripts/lib'

require 'test/unit'
require 'webpub/publisher'

class WebProjectTest < Test::Unit::TestCase

	include WebPub

	def test_create_web_project
		dir = 'test_resources/webproject001'
		proj = WebProject.new(dir)
		
		assert_not_nil(proj)
		
		assert_not_nil( %r!webproject001/ht_sources! === proj.htsources_dir)
		assert_not_nil( %r!webproject001/scripts! === proj.scripts_dir)
		assert_not_nil( %r!webproject001/public_html! === proj.publish_dir)
	end
	
	def test_web_project_manager
		path = File.expand_path 'test_resources/webproject001/ht_sources/folder2/home.html'
		
		manager = WebPub::WebProjectManager.instance
		
		# create project descttion
		proj = manager.find_web_project(path)
		assert_not_nil( %r!.+webproject001/ht_sources$! === proj.htsources_dir)
		
		# cache enabled
		assert_equal( proj.hash, manager.find_web_project(File.expand_path('test_resources/webproject001')).hash )
	end

	

end
