#
# $Id: rftools_test.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

project_dir = File.dirname(__FILE__).sub(/(com.narucy.webpub.core).+/, '\1')
Dir.chdir project_dir
$: << project_dir + '/scripts/lib'

require 'test/unit'
require 'webpub/rftools'

class PublisherTest < Test::Unit::TestCase

	def test_mkdirs
		begin
			(0 .. 2).each { # same dir is not mkdir and no error
				dir = ENV['TEMP'] + '/a/b/c'
				Dir.mkdirs(dir)
				assert File.exist?(dir)
				
				dir += '/d/e'
				Dir.mkdirs(dir)
				
				assert File.exist?(dir)
				assert File.exist?(ENV['TEMP'] + '/a')
			}			
		ensure
			File.rm_all(ENV['TEMP'] + '/a')
		end
	end
	

end