#
# $Id: rftools.rb,v 1.1 2004/01/17 12:02:25 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'ftools'
require 'webpub/dirtools'

class << File

	def rm_all(dir)
		Dir.glob(dir + '/*', File::FNM_DOTMATCH) { |f|
			unless /\.$/ === f
				if File.file? f
					File.delete f
				elsif File.directory? f
					rm_all f
				end
			end
		}
		Dir.delete(dir)
	end
	
	def cp_all(dir, todir)
		Dir.mkdir todir unless File.exist? todir
		Dir.glob(dir + '/*', File::FNM_DOTMATCH) { |f|
			next if /\.$/ === f
			if File.file? f
				File.cp(f, todir)
			elsif File.directory? f
				d = File.join(todir, File.basename(f))
				Dir.mkdir(d)
				cp_all( f, d)
			end
		}
	end

end


class << Dir

	def mkdirs(target_path)
		unexist_dir = []
		DirTools.dir_iter(target_path) { |d|
			break if File.exist? d
			unexist_dir << d
		}
		# p unexist_dir
		unexist_dir.reverse.each { |d|
			Dir.mkdir d
		}
		Dir.mkdir(target_path) unless File.exist? target_path
	end

end
