#
# $Id: publisher.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'rexml/document'
require 'webpub/dirtools'
require 'webpub/webproject'

=begin

= publisher.rb

publisher.rb defines base classes.

=end
module WebPub

PUBLISH_PROPERTY_FILENAME = ".publish"

class Publisher

	def publish(publish_desc)
		# abstract method.
	end

	def ht_distribute(desc, lines)
		desc.ht_filters.each { |filter|
			lines = filter.respond_to?(:call) ?
				filter.call(desc, lines) :
				filter.filter(desc, lines)
		}
		open(desc.publish_to, 'w') { |fh|
			fh << lines
		}
	end

end

class HTFilter

	##
	# Filtering text.
	# 
	# @return filted lines.
	def filter(publish_desc, lines)
	end

end

class PublishDescription

	BY_COPY = 'copy'

	def initialize(by, web_proj)
		raise ArgumentError, 'need to specify publish code' unless by
		@by = by
		@web_project = web_proj
		@publish_from = nil
		@publish_to = nil
		@arguments = {}
		
		@ht_filters = []
		# @io_filters = [] # for image publihing. (low priority feature)
	end
	
	attr_reader :by, :web_project, :arguments, :ht_filters
	attr_accessor :publish_from, :publish_to
	
	def ht_filter?(desc)
		exts = @web_project.entries['ht_extensions'] || 'html htm erb'
		exts.split.each { |ext|
			return true if /\.#{ext}$/ === desc.publish_to
		}
		false
	end

end

class PublishDescriptionFactory

	def initialize
	end
	
	def create(from)
		from = File.expand_path(from)
		
		web_project = WebProjectManager.instance.find_web_project(from)
		#return unless web_project
		raise ArgumentError, "not found project coniguration file from specify resource:" + from unless web_project
		
		map = choose_prop_from_file(from) if File.file?(from)
		unless map
			map = choose_prop_from_dir(from)
			return unless map
		end
		unless by = map['by']
			$stdout << "can not get publiing code (#{map}): #{from}\n"
			return
		end
		
		desc = PublishDescription.new(by, web_project)
		desc.publish_from = from
		
		# difinication publish_to
		if to = map['publish_to']
			# exist "publish_to" attribute publish to specify location.
			
			# if specify wild card style, rename extension
			if %r!(.+/)\*(\..+?)$! === to
				to = $1 + File.basename(from).gsub(/\..+?$/, $2)
			elsif %r!/$! === to
				# if publish location line is end "/", append publish from basename.
				to += File.basename(from)
			end
			
			to = File.join(web_project.publish_dir, to)
		elsif /#{web_project.htsources_dir}\/.+/ === from
			to = from.sub( /#{web_project.htsources_dir}/, web_project.publish_dir)
		else
			$stdout << "can't define publish location (Invalid publish locaion?): #{from} : #{desc.inspect}\n"
			return
		end
		
		# set arguments
		desc.publish_to = to
		map.each { |k, v|
			desc.arguments[k] = v unless %w!publish_to by!.include? k
		}
		
		# set initial filter
		if desc.ht_filter?(desc)
			require 'webpub/abstorel_filter'
			desc.ht_filters << AbsToRelFilter.new
		end
		
		desc
	end
	
	private
	
	def choose_prop_from_dir(from)
		web_project = WebProjectManager.instance.find_web_project(from)
		
		DirTools.dir_iter(from) { |dir|
			if File.exist?( f = File.join(dir, PUBLISH_PROPERTY_FILENAME) )
				root = REXML::Document.new(IO.read(f)).root
				
				target_elem = nil
				root.each_element('**/mapping') { |e|
					pattern = e.attributes['pattern']
					if File.basename(from) == pattern or
						(%r!^/.+/$! === pattern and /#{pattern[1, pattern.length-2]}/ === from) or
						File::fnmatch(pattern, from)
						
						return e.elements['publish'].attributes
					end
				}
			end
			
			if web_project.htsources_dir == dir
				return {'by' => PublishDescription::BY_COPY}
			end
		}
		
		nil
	end

	def choose_prop_from_file(file)
		content = nil
		IO.foreach(file) { |l|
			if content = /<\?publish(.+)\?>/.match(l) 
				attrs = {}
				content[1].scan(/(.+?)\s*=\s*"(.+?)"/) { |m|
					attrs[ m[0].strip ] = m[1]
				}
				return attrs
			end
		}
		nil
	end

end

end