#
# $Id: publish_manager_test.rb,v 1.1 2004/01/17 12:02:27 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

project_dir = File.dirname(__FILE__).sub(/(com.narucy.webpub.core).+/, '\1')
Dir.chdir project_dir
$: << project_dir + '/scripts/lib'

require 'test/unit'
require 'webpub/publish_manager'

module A
module B
module C
class DummyPublisher1 < WebPub::Publisher
	def publish(req)
		$DummyPublisher1_flag = true
	end
end
end
end
end

class DummyPublisher2 < WebPub::Publisher
	def publish(req)
		$DummyPublisher2_flag = true
	end
end

class PublisherManagerTest < Test::Unit::TestCase

	def setup
		@proj_location = 'test_resources/webproject001'
		@tmpdir = ENV['TEMP'] + '/amrita_publisher_test' + rand(100).to_s
		
		File.cp_all(@proj_location, @tmpdir)
	end

	def create_dummy(name, by)
		open( name = @tmpdir + '/ht_sources/' + name, 'w') { |fh|
			fh << %Q!<?publish by="#{by}"?>!
		}
		name
	end
	
	def test_invoke_pub
		dir = File.dirname(__FILE__)
			
		config = [
			['dummy1', __FILE__, 'A::B::C::DummyPublisher1'],
			['dummy2', __FILE__, 'DummyPublisher2'],
		]
	
		pubconf_file = ENV['TEMP'] + '/publish_properties'
		begin
			open(pubconf_file, 'w') { |fh|
				config.each { |a|
					fh << a.join(',') + "\n"
				}
			}
			
			manager = WebPub::PublishManager.new(pubconf_file)
			manager.publish([create_dummy('d1.htm', 'dummy1')], 'dummy1')
			manager.publish([create_dummy('d2.htm', 'dummy2')], 'dummy2')
			
			assert $DummyPublisher1_flag
			assert $DummyPublisher2_flag
		ensure
			File.delete( pubconf_file )
		end
	end

	def teardown
		begin
			File.rm_all(@tmpdir)
		rescue
		end
	end
end
