#
# $Id: eclipse_workspace.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'singleton'

class EclipseWorkspace

	include Singleton

	def initialize
	end

	def find_project(proj_name)
		wp = $WORKSPACE_PATH || '.'
		
		Dir.glob(File.join(wp, '*') ){ |d|
			return d if File.basename(d) == proj_name and File.directory?(d)
		}
		Dir.glob(File.join(wp, '.metadata/.plugins/org.eclipse.core.resources/.projects/*/.location') ).each { |f|
			return choose_project_path(f) if %r!#{proj_name}/\.location$! === f
		}
		nil
	end

	def choose_project_path(f)
		open(f, 'rb') { |fh|
			result = ''
			byte_count = 0
			fh.each_byte { |b|
				byte_count+=1
				return result if b == 192 and byte_count >= 19
				result << b if byte_count >= 19
			}
		}
		nil
	end

end
