#
# $Id: amrita_wz_rd_publisher.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'webpub/publisher'
require 'rd/rdfmt'
require 'amrita/format'
require 'webpub/amrita_publisher'

=begin

TODO: complete equipment command line tools

* reading HTGenerationDescription and to create as that datas.

=end

module WebPub

class AmritaWzRDPublisher < AmritaPublisher

	def initialize
		super
	end

	def rd_to_html(src)
		visitor = nil
		begin
			require 'rd/rd2html-ext-lib'
			visitor = $Visitor_Class.new
			visitor.opt_ref_extension = true
		rescue LoadError
			require 'rd/rd2html-lib'
			visitor = $Visitor_Class.new
		end
	
		visitor.charset = 'utf-8'
		tree = RD::RDTree.new(src, [], nil)
		tree.parse
		visitor.visit(tree)
	end

	def create_template( desc )
		TemplateFile.new( desc.arguments['template'] )
	end

	def create_memberobj( desc)
		memberobj = super(desc)
		
		rdlines = IO.readlines(desc.publish_from).join('')
		
		# choose_title.
		rdlines.each { |l|
			if /^=\s+(.+)$/ === l
				memberobj[:title] = $1
				break
			elsif /^#(.+?):(.+)$/ === l
				memberobj[$1.strip.intern] = $2.strip
			end
		}
		
		# choose html converted rd body lines.
		current_dir = Dir.pwd
		begin
			dir = desc.publish_from.gsub(%r!(.+/).+?$!, "\\1")
			Dir.chdir(dir)
			htlines = rd_to_html(rdlines)
			rd_body = htlines.gsub(%r!^.+<body>(.+)</body>.+$!m, "\\1")
			memberobj[:rd_body] = SanitizedString[ rd_body ]
		ensure
			Dir.chdir(current_dir)
		end
		
		memberobj
	end

end

end